/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.web.client.RestTemplateMetricsConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.web.client.WebClientMetricsConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
@Import(value={RestTemplateMetricsConfiguration.class, WebClientMetricsConfiguration.class})
public class HttpClientMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public HttpClientMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Order(value=0)
    public MeterFilter metricsHttpClientUriTagFilter() {
        String metricName = this.properties.getWeb().getClient().getRequestsMetricName();
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'. Are you using 'uriVariables'?", metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.properties.getWeb().getClient().getMaxUriTags(), (MeterFilter)denyFilter);
    }
}

