/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class OnlyOnceLoggingDenyMeterFilter
implements MeterFilter {
    private final Logger logger = LoggerFactory.getLogger(OnlyOnceLoggingDenyMeterFilter.class);
    private final AtomicBoolean alreadyWarned = new AtomicBoolean(false);
    private final Supplier<String> message;

    public OnlyOnceLoggingDenyMeterFilter(Supplier<String> message) {
        Assert.notNull(message, (String)"Message must not be null");
        this.message = message;
    }

    public MeterFilterReply accept(Meter.Id id) {
        if (this.logger.isWarnEnabled() && this.alreadyWarned.compareAndSet(false, true)) {
            this.logger.warn(this.message.get());
        }
        return MeterFilterReply.DENY;
    }
}

