/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.support;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAndroidClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class HttpAccessor {
    private static final String TAG = HttpAccessor.class.getSimpleName();
    private static final boolean httpClient43Present = ClassUtils.isPresent((String)"org.apache.http.impl.client.CloseableHttpClient", (ClassLoader)HttpAccessor.class.getClassLoader());
    private ClientHttpRequestFactory requestFactory = httpClient43Present ? new HttpComponentsClientHttpRequestFactory() : (Build.VERSION.SDK_INT >= 9 ? new SimpleClientHttpRequestFactory() : new HttpComponentsAndroidClientHttpRequestFactory());

    protected HttpAccessor() {
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"'requestFactory' must not be null");
        this.requestFactory = requestFactory;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
        ClientHttpRequest request = this.getRequestFactory().createRequest(url, method);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Created " + method.name() + " request for \"" + url + "\""));
        }
        return request;
    }
}

