/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageBatchRecoverer;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.interceptor.StatefulRetryOperationsInterceptor;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class StatefulRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private static Log logger = LogFactory.getLog(StatefulRetryOperationsInterceptorFactoryBean.class);
    private MessageKeyGenerator messageKeyGenerator;
    private NewMessageIdentifier newMessageIdentifier;

    public void setMessageKeyGenerator(MessageKeyGenerator messageKeyGenerator) {
        this.messageKeyGenerator = messageKeyGenerator;
    }

    public void setNewMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
        this.newMessageIdentifier = newMessageIdentifier;
    }

    public StatefulRetryOperationsInterceptor getObject() {
        StatefulRetryOperationsInterceptor retryInterceptor = new StatefulRetryOperationsInterceptor();
        RetryOperations retryTemplate = this.getRetryOperations();
        if (retryTemplate == null) {
            retryTemplate = new RetryTemplate();
        }
        retryInterceptor.setRetryOperations(retryTemplate);
        retryInterceptor.setNewItemIdentifier(this.createNewItemIdentifier());
        retryInterceptor.setRecoverer(this.createRecoverer());
        retryInterceptor.setKeyGenerator(this.createKeyGenerator());
        return retryInterceptor;
    }

    private NewMethodArgumentsIdentifier createNewItemIdentifier() {
        return args -> {
            Message message = this.argToMessage(args);
            if (this.newMessageIdentifier == null) {
                return message.getMessageProperties().isRedelivered() == false;
            }
            return this.newMessageIdentifier.isNew(message);
        };
    }

    private MethodInvocationRecoverer<?> createRecoverer() {
        return (args, cause) -> {
            MessageRecoverer messageRecoverer = this.getMessageRecoverer();
            Object arg = args[1];
            if (messageRecoverer == null) {
                logger.warn((Object)("Message(s) dropped on recovery: " + String.valueOf(arg)), cause);
            } else if (arg instanceof Message) {
                Message msg = (Message)arg;
                messageRecoverer.recover(msg, cause);
            } else if (arg instanceof List && messageRecoverer instanceof MessageBatchRecoverer) {
                MessageBatchRecoverer recoverer = (MessageBatchRecoverer)messageRecoverer;
                recoverer.recover((List)arg, cause);
            }
            throw new ImmediateAcknowledgeAmqpException("Recovered message forces ack (if ack mode requires it): " + String.valueOf(arg), cause);
        };
    }

    private MethodArgumentsKeyGenerator createKeyGenerator() {
        return args -> {
            Message message = this.argToMessage(args);
            Assert.notNull((Object)message, (String)"The 'args' must not convert to null");
            if (this.messageKeyGenerator == null) {
                String messageId = message.getMessageProperties().getMessageId();
                if (messageId == null && message.getMessageProperties().isRedelivered().booleanValue()) {
                    message.getMessageProperties().setFinalRetryForMessageWithNoId(true);
                }
                return messageId;
            }
            return this.messageKeyGenerator.getKey(message);
        };
    }

    @Nullable
    private Message argToMessage(Object[] args) {
        Object arg = args[1];
        if (arg instanceof Message) {
            Message msg = (Message)arg;
            return msg;
        }
        if (arg instanceof List) {
            List list = (List)arg;
            return (Message)list.get(0);
        }
        return null;
    }

    public Class<?> getObjectType() {
        return StatefulRetryOperationsInterceptor.class;
    }
}

