/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.AddressResolver;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeConnectionListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionBlockedEvent;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.ConnectionUnblockedEvent;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractConnectionFactory
implements ConnectionFactory,
DisposableBean,
BeanNameAware,
ApplicationContextAware,
ApplicationEventPublisherAware,
ApplicationListener<ContextClosedEvent> {
    private static final String PUBLISHER_SUFFIX = ".publisher";
    public static final int DEFAULT_CLOSE_TIMEOUT = 30000;
    private static final String BAD_URI = "setUri() was passed an invalid URI; it is ignored";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory;
    private final CompositeConnectionListener connectionListener = new CompositeConnectionListener();
    private final CompositeChannelListener channelListener = new CompositeChannelListener();
    private final AtomicInteger defaultConnectionNameStrategyCounter = new AtomicInteger();
    private AbstractConnectionFactory publisherConnectionFactory;
    private RecoveryListener recoveryListener = new RecoveryListener(){

        public void handleRecoveryStarted(Recoverable recoverable) {
            if (AbstractConnectionFactory.this.logger.isDebugEnabled()) {
                AbstractConnectionFactory.this.logger.debug((Object)("Connection recovery started: " + recoverable));
            }
        }

        public void handleRecovery(Recoverable recoverable) {
            if (AbstractConnectionFactory.this.logger.isDebugEnabled()) {
                AbstractConnectionFactory.this.logger.debug((Object)("Connection recovery complete: " + recoverable));
            }
        }
    };
    private ExecutorService executorService;
    private List<Address> addresses;
    private boolean shuffleAddresses;
    private int closeTimeout = 30000;
    private ConnectionNameStrategy connectionNameStrategy = connectionFactory -> (this.beanName != null ? this.beanName : "SpringAMQP") + "#" + ObjectUtils.getIdentityHexString((Object)this) + ":" + this.defaultConnectionNameStrategyCounter.getAndIncrement();
    private String beanName;
    private ApplicationContext applicationContext;
    private ApplicationEventPublisher applicationEventPublisher;
    private AddressResolver addressResolver;
    private volatile boolean contextStopped;

    public AbstractConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) {
        Assert.notNull((Object)rabbitConnectionFactory, (String)"Target ConnectionFactory must not be null");
        this.rabbitConnectionFactory = rabbitConnectionFactory;
    }

    protected final void setPublisherConnectionFactory(AbstractConnectionFactory publisherConnectionFactory) {
        this.publisherConnectionFactory = publisherConnectionFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setApplicationContext(applicationContext);
        }
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setApplicationEventPublisher(applicationEventPublisher);
        }
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.getApplicationContext() == event.getApplicationContext()) {
            this.contextStopped = true;
        }
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.onApplicationEvent(event);
        }
    }

    protected boolean getContextStopped() {
        return this.contextStopped;
    }

    public com.rabbitmq.client.ConnectionFactory getRabbitConnectionFactory() {
        return this.rabbitConnectionFactory;
    }

    @Override
    public String getUsername() {
        return this.rabbitConnectionFactory.getUsername();
    }

    public void setUsername(String username) {
        this.rabbitConnectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.rabbitConnectionFactory.setPassword(password);
    }

    public void setHost(String host) {
        this.rabbitConnectionFactory.setHost(host);
    }

    public void setConnectionThreadFactory(ThreadFactory threadFactory) {
        this.rabbitConnectionFactory.setThreadFactory(threadFactory);
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public void setUri(URI uri) {
        try {
            this.rabbitConnectionFactory.setUri(uri);
        }
        catch (URISyntaxException | GeneralSecurityException use) {
            this.logger.info((Object)BAD_URI, (Throwable)use);
        }
    }

    public void setUri(String uri) {
        try {
            this.rabbitConnectionFactory.setUri(uri);
        }
        catch (URISyntaxException | GeneralSecurityException use) {
            this.logger.info((Object)BAD_URI, (Throwable)use);
        }
    }

    @Override
    public String getHost() {
        return this.rabbitConnectionFactory.getHost();
    }

    public void setVirtualHost(String virtualHost) {
        this.rabbitConnectionFactory.setVirtualHost(virtualHost);
    }

    @Override
    public String getVirtualHost() {
        return this.rabbitConnectionFactory.getVirtualHost();
    }

    public void setPort(int port) {
        this.rabbitConnectionFactory.setPort(port);
    }

    public void setRequestedHeartBeat(int requestedHeartBeat) {
        this.rabbitConnectionFactory.setRequestedHeartbeat(requestedHeartBeat);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.rabbitConnectionFactory.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public int getPort() {
        return this.rabbitConnectionFactory.getPort();
    }

    public void setAddresses(String addresses) {
        Address[] addressArray;
        if (StringUtils.hasText((String)addresses) && (addressArray = Address.parseAddresses((String)addresses)).length > 0) {
            this.addresses = Arrays.asList(addressArray);
            if (this.publisherConnectionFactory != null) {
                this.publisherConnectionFactory.setAddresses(addresses);
            }
            return;
        }
        this.logger.info((Object)"setAddresses() called with an empty value, will be using the host+port  or addressResolver properties for connections");
        this.addresses = null;
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        this.connectionListener.setDelegates(listeners);
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setConnectionListeners(listeners);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addDelegate(listener);
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.addConnectionListener(listener);
        }
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean result = this.connectionListener.removeDelegate(listener);
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.removeConnectionListener(listener);
        }
        return result;
    }

    @Override
    public void clearConnectionListeners() {
        this.connectionListener.clearDelegates();
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.clearConnectionListeners();
        }
    }

    public void setChannelListeners(List<? extends ChannelListener> listeners) {
        this.channelListener.setDelegates(listeners);
    }

    public void setRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListener = recoveryListener;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setRecoveryListener(recoveryListener);
        }
    }

    public void addChannelListener(ChannelListener listener) {
        this.channelListener.addDelegate(listener);
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.addChannelListener(listener);
        }
    }

    public void setExecutor(Executor executor) {
        boolean isExecutorService = executor instanceof ExecutorService;
        boolean isThreadPoolTaskExecutor = executor instanceof ThreadPoolTaskExecutor;
        Assert.isTrue((isExecutorService || isThreadPoolTaskExecutor ? 1 : 0) != 0, (String)"'executor' must be an 'ExecutorService' or a 'ThreadPoolTaskExecutor'");
        this.executorService = isExecutorService ? (ExecutorService)executor : ((ThreadPoolTaskExecutor)executor).getThreadPoolExecutor();
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setExecutor(executor);
        }
    }

    @Nullable
    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setCloseTimeout(closeTimeout);
        }
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setConnectionNameStrategy(ConnectionNameStrategy connectionNameStrategy) {
        this.connectionNameStrategy = connectionNameStrategy;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setConnectionNameStrategy(cf -> connectionNameStrategy.obtainNewConnectionName(cf) + PUBLISHER_SUFFIX);
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.setBeanName(name + PUBLISHER_SUFFIX);
        }
    }

    @Nullable
    protected String getBeanName() {
        return this.beanName;
    }

    public void setShuffleAddresses(boolean shuffleAddresses) {
        this.shuffleAddresses = shuffleAddresses;
    }

    public boolean hasPublisherConnectionFactory() {
        return this.publisherConnectionFactory != null;
    }

    @Override
    public ConnectionFactory getPublisherConnectionFactory() {
        return this.publisherConnectionFactory;
    }

    protected final Connection createBareConnection() {
        try {
            String connectionName = this.connectionNameStrategy.obtainNewConnectionName(this);
            com.rabbitmq.client.Connection rabbitConnection = this.connect(connectionName);
            final SimpleConnection connection = new SimpleConnection(rabbitConnection, this.closeTimeout);
            if (rabbitConnection instanceof AutorecoveringConnection) {
                ((AutorecoveringConnection)rabbitConnection).addRecoveryListener(new RecoveryListener(){

                    public void handleRecoveryStarted(Recoverable recoverable) {
                        this.handleRecovery(recoverable);
                    }

                    public void handleRecovery(Recoverable recoverable) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            AbstractConnectionFactory.this.logger.error((Object)"Failed to close auto-recover connection", (Throwable)e);
                        }
                    }
                });
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Created new connection: " + connectionName + "/" + connection));
            }
            if (this.recoveryListener != null && rabbitConnection instanceof AutorecoveringConnection) {
                ((AutorecoveringConnection)rabbitConnection).addRecoveryListener(this.recoveryListener);
            }
            if (this.applicationEventPublisher != null) {
                connection.addBlockedListener(new ConnectionBlockedListener(connection, this.applicationEventPublisher));
            }
            return connection;
        }
        catch (IOException | TimeoutException ex) {
            RuntimeException converted = RabbitExceptionTranslator.convertRabbitAccessException(ex);
            this.connectionListener.onFailed(ex);
            throw converted;
        }
    }

    private com.rabbitmq.client.Connection connect(String connectionName) throws IOException, TimeoutException {
        if (this.addressResolver != null) {
            return this.connectResolver(connectionName);
        }
        if (this.addresses != null) {
            return this.connectAddresses(connectionName);
        }
        return this.connectHostPort(connectionName);
    }

    private com.rabbitmq.client.Connection connectResolver(String connectionName) throws IOException, TimeoutException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Attempting to connect with: " + this.addressResolver));
        }
        return this.rabbitConnectionFactory.newConnection(this.executorService, this.addressResolver, connectionName);
    }

    private com.rabbitmq.client.Connection connectAddresses(String connectionName) throws IOException, TimeoutException {
        List<Address> addressesToConnect = this.addresses;
        if (this.shuffleAddresses && addressesToConnect.size() > 1) {
            ArrayList<Address> list = new ArrayList<Address>(addressesToConnect);
            Collections.shuffle(list);
            addressesToConnect = list;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Attempting to connect to: " + addressesToConnect));
        }
        return this.rabbitConnectionFactory.newConnection(this.executorService, addressesToConnect, connectionName);
    }

    private com.rabbitmq.client.Connection connectHostPort(String connectionName) throws IOException, TimeoutException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Attempting to connect to: " + this.rabbitConnectionFactory.getHost() + ":" + this.rabbitConnectionFactory.getPort()));
        }
        return this.rabbitConnectionFactory.newConnection(this.executorService, connectionName);
    }

    protected final String getDefaultHostName() {
        String temp;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            temp = localMachine.getHostName();
            this.logger.debug((Object)("Using hostname [" + temp + "] for hostname."));
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Could not get host name, using 'localhost' as default value", (Throwable)e);
            temp = "localhost";
        }
        return temp;
    }

    public void destroy() {
        if (this.publisherConnectionFactory != null) {
            this.publisherConnectionFactory.destroy();
        }
    }

    public String toString() {
        if (this.beanName != null) {
            return this.beanName;
        }
        return super.toString();
    }

    private static final class ConnectionBlockedListener
    implements BlockedListener {
        private final Connection connection;
        private final ApplicationEventPublisher applicationEventPublisher;

        ConnectionBlockedListener(Connection connection, ApplicationEventPublisher applicationEventPublisher) {
            this.connection = connection;
            this.applicationEventPublisher = applicationEventPublisher;
        }

        public void handleBlocked(String reason) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ConnectionBlockedEvent(this.connection, reason));
        }

        public void handleUnblocked() {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ConnectionUnblockedEvent(this.connection));
        }
    }
}

