/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.milvus;

import io.micrometer.observation.ObservationRegistry;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import java.util.concurrent.TimeUnit;
import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusServiceClientConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusServiceClientProperties;
import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.milvus.MilvusVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={MilvusVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={MilvusServiceClientProperties.class, MilvusVectorStoreProperties.class})
public class MilvusVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MilvusServiceClientConnectionDetails.class})
    PropertiesMilvusServiceClientConnectionDetails milvusServiceClientConnectionDetails(MilvusServiceClientProperties properties) {
        return new PropertiesMilvusServiceClientConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy milvusBatchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public MilvusVectorStore vectorStore(MilvusServiceClient milvusClient, EmbeddingModel embeddingModel, MilvusVectorStoreProperties properties, BatchingStrategy batchingStrategy, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention) {
        return ((MilvusVectorStore.Builder)((MilvusVectorStore.Builder)MilvusVectorStore.builder((MilvusServiceClient)milvusClient, (EmbeddingModel)embeddingModel).initializeSchema(properties.isInitializeSchema()).batchingStrategy(batchingStrategy).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MilvusServiceClient milvusClient(MilvusVectorStoreProperties serverProperties, MilvusServiceClientProperties clientProperties, MilvusServiceClientConnectionDetails connectionDetails) {
        ConnectParam.Builder builder = ConnectParam.newBuilder().withHost(connectionDetails.getHost()).withPort(connectionDetails.getPort()).withDatabaseName(serverProperties.getDatabaseName()).withConnectTimeout(clientProperties.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).withKeepAliveTime(clientProperties.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).withKeepAliveTimeout(clientProperties.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).withRpcDeadline(clientProperties.getRpcDeadlineMs(), TimeUnit.MILLISECONDS).withSecure(clientProperties.isSecure()).withIdleTimeout(clientProperties.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).withAuthorization(clientProperties.getUsername(), clientProperties.getPassword());
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getUri())) {
            builder.withUri(clientProperties.getUri());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getToken())) {
            builder.withToken(clientProperties.getToken());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getClientKeyPath())) {
            builder.withClientKeyPath(clientProperties.getClientKeyPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getClientPemPath())) {
            builder.withClientPemPath(clientProperties.getClientPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getCaPemPath())) {
            builder.withCaPemPath(clientProperties.getCaPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getServerPemPath())) {
            builder.withServerPemPath(clientProperties.getServerPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getServerName())) {
            builder.withServerName(clientProperties.getServerName());
        }
        return new MilvusServiceClient(builder.build());
    }

    static class PropertiesMilvusServiceClientConnectionDetails
    implements MilvusServiceClientConnectionDetails {
        private final MilvusServiceClientProperties properties;

        PropertiesMilvusServiceClientConnectionDetails(MilvusServiceClientProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }
    }
}

