/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util;

import com.fasterxml.jackson.databind.Module;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;

public abstract class JacksonUtils {
    public static List<Module> instantiateAvailableModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        try {
            Class<?> jdk8ModuleClass = Class.forName("com.fasterxml.jackson.datatype.jdk8.Jdk8Module");
            Module jdk8Module = (Module)BeanUtils.instantiateClass(jdk8ModuleClass);
            modules.add(jdk8Module);
        }
        catch (ClassNotFoundException jdk8ModuleClass) {
            // empty catch block
        }
        try {
            Class<?> javaTimeModuleClass = Class.forName("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule");
            Module javaTimeModule = (Module)BeanUtils.instantiateClass(javaTimeModuleClass);
            modules.add(javaTimeModule);
        }
        catch (ClassNotFoundException javaTimeModuleClass) {
            // empty catch block
        }
        try {
            Class<?> parameterNamesModuleClass = Class.forName("com.fasterxml.jackson.module.paramnames.ParameterNamesModule");
            Module parameterNamesModule = (Module)BeanUtils.instantiateClass(parameterNamesModuleClass);
            modules.add(parameterNamesModule);
        }
        catch (ClassNotFoundException parameterNamesModuleClass) {
            // empty catch block
        }
        if (KotlinDetector.isKotlinPresent()) {
            try {
                Class<?> kotlinModuleClass = Class.forName("com.fasterxml.jackson.module.kotlin.KotlinModule");
                Module kotlinModule = (Module)BeanUtils.instantiateClass(kotlinModuleClass);
                modules.add(kotlinModule);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return modules;
    }
}

