/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.RepositoryRestResourceProvider;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.webmvc.api.OpenApiActuatorResource;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springdoc.webmvc.api.OpenApiWebMvcResource;
import org.springdoc.webmvc.core.RouterFunctionProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public abstract class MultipleOpenApiResource
implements InitializingBean {
    private final List<GroupedOpenApi> groupedOpenApis;
    private final ObjectFactory<OpenAPIService> defaultOpenAPIBuilder;
    private final AbstractRequestService requestBuilder;
    private final GenericResponseService responseBuilder;
    private final OperationService operationParser;
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<ActuatorProvider> actuatorProvider;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider;
    private Map<String, OpenApiResource> groupedOpenApiResources;
    private final Optional<RouterFunctionProvider> routerFunctionProvider;
    private final Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider;

    public MultipleOpenApiResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIService> defaultOpenAPIBuilder, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> actuatorProvider, SpringDocConfigProperties springDocConfigProperties, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider) {
        this.groupedOpenApis = groupedOpenApis;
        this.defaultOpenAPIBuilder = defaultOpenAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.actuatorProvider = actuatorProvider;
        this.springDocConfigProperties = springDocConfigProperties;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
        this.repositoryRestResourceProvider = repositoryRestResourceProvider;
    }

    public void afterPropertiesSet() throws Exception {
        this.groupedOpenApiResources = this.groupedOpenApis.stream().collect(Collectors.toMap(GroupedOpenApi::getGroup, item -> {
            SpringDocConfigProperties.GroupConfig groupConfig = new SpringDocConfigProperties.GroupConfig(item.getGroup(), item.getPathsToMatch(), item.getPackagesToScan(), item.getPackagesToExclude(), item.getPathsToExclude(), item.getProducesToMatch(), item.getConsumesToMatch(), item.getHeadersToMatch());
            this.springDocConfigProperties.addGroupConfig(groupConfig);
            return this.buildWebMvcOpenApiResource((GroupedOpenApi)item);
        }));
    }

    private OpenApiResource buildWebMvcOpenApiResource(GroupedOpenApi item) {
        if (!this.springDocConfigProperties.isUseManagementPort() && !"x-actuator".equals(item.getGroup())) {
            return new OpenApiWebMvcResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, this.requestMappingHandlerMapping, this.actuatorProvider, Optional.of(item.getOperationCustomizers()), Optional.of(item.getOpenApiCustomisers()), this.springDocConfigProperties, this.springSecurityOAuth2Provider, this.routerFunctionProvider, this.repositoryRestResourceProvider);
        }
        return new OpenApiActuatorResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, this.requestMappingHandlerMapping, this.actuatorProvider, Optional.of(item.getOperationCustomizers()), Optional.of(item.getOpenApiCustomisers()), this.springDocConfigProperties, this.springSecurityOAuth2Provider, this.routerFunctionProvider, this.repositoryRestResourceProvider);
    }

    protected OpenApiResource getOpenApiResourceOrThrow(String group) {
        OpenApiResource openApiResource = this.groupedOpenApiResources.get(group);
        if (openApiResource == null) {
            throw new OpenApiResourceNotFoundException("No OpenAPI resource found for group: " + group);
        }
        return openApiResource;
    }
}

