/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerWelcomeWebFlux
extends SwaggerWelcomeCommon {
    private final SpringWebProvider springWebProvider;
    private String pathPrefix;

    public SwaggerWelcomeWebFlux(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, SpringWebProvider springWebProvider) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.springWebProvider = springWebProvider;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            this.oauthPrefix = uriComponentsBuilder.path(this.contextPath).path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(this.oauthPrefix.path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected String buildApiDocUrl() {
        return this.buildUrlWithContextPath(this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildUrlWithContextPath(String swaggerUiUrl) {
        if (this.pathPrefix == null) {
            this.pathPrefix = this.springWebProvider.findPathPrefix(this.springDocConfigProperties);
        }
        return this.buildUrl(this.contextPath + this.pathPrefix, swaggerUiUrl);
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/" + "swagger-config";
    }
}

