/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class HateoasHalProvider {
    protected final ObjectMapperProvider objectMapperProvider;
    private final Optional<HateoasProperties> hateoasPropertiesOptional;

    public HateoasHalProvider(Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        this.hateoasPropertiesOptional = hateoasPropertiesOptional;
        this.objectMapperProvider = objectMapperProvider;
    }

    @PostConstruct
    protected void init() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    public boolean isHalEnabled() {
        return this.hateoasPropertiesOptional.map(HateoasHalProvider::isHalEnabled).orElse(true);
    }

    private static boolean isHalEnabled(@NonNull HateoasProperties hateoasProperties) {
        List<String> possibleMethodNames = List.of("isUseHalAsDefaultJsonMediaType", "getUseHalAsDefaultJsonMediaType");
        for (String methodName : possibleMethodNames) {
            Method method = ReflectionUtils.findMethod(HateoasProperties.class, (String)methodName);
            if (method == null) continue;
            Object result = ReflectionUtils.invokeMethod((Method)method, (Object)hateoasProperties);
            if (result instanceof Boolean) {
                Boolean halEnabled = (Boolean)result;
                return halEnabled;
            }
            throw new IllegalStateException("Method " + methodName + " did not return a boolean value");
        }
        throw new IllegalStateException("No suitable method found to determine if HAL is enabled");
    }
}

