/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.properties.SpringDocConfigProperties;

public class ModelConverterRegistrar {
    private final ModelConverters modelConvertersInstance;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelConverterRegistrar.class);

    public ModelConverterRegistrar(List<ModelConverter> modelConverters, SpringDocConfigProperties springDocConfigProperties) {
        this.modelConvertersInstance = ModelConverters.getInstance((boolean)springDocConfigProperties.isOpenapi31());
        for (ModelConverter modelConverter : modelConverters) {
            Optional<ModelConverter> registeredConverterOptional = this.getRegisteredConverterSameAs(modelConverter);
            registeredConverterOptional.ifPresent(arg_0 -> ((ModelConverters)this.modelConvertersInstance).removeConverter(arg_0));
            this.modelConvertersInstance.addConverter(modelConverter);
        }
    }

    private Optional<ModelConverter> getRegisteredConverterSameAs(ModelConverter modelConverter) {
        try {
            List modelConverters = (List)FieldUtils.readDeclaredField((Object)this.modelConvertersInstance, (String)"converters", (boolean)true);
            return modelConverters.stream().filter(registeredModelConverter -> this.isSameConverter((ModelConverter)registeredModelConverter, modelConverter)).findFirst();
        }
        catch (IllegalAccessException exception) {
            LOGGER.warn(exception.getMessage());
            return Optional.empty();
        }
    }

    private boolean isSameConverter(ModelConverter modelConverter1, ModelConverter modelConverter2) {
        Class modelConverter1Class = modelConverter1.getClass();
        Class modelConverter2Class = modelConverter2.getClass();
        return modelConverter1Class.getName().equals(modelConverter2Class.getName());
    }
}

