/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.converters.PolymorphicModelConverter;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;

public class SpringDocUtils {
    private static final SpringDocUtils springDocConfig = new SpringDocUtils();

    private SpringDocUtils() {
    }

    public static SpringDocUtils getConfig() {
        return springDocConfig;
    }

    public SpringDocUtils addDeprecatedType(Class<? extends Annotation> cls) {
        SchemaPropertyDeprecatingConverter.addDeprecatedType(cls);
        return this;
    }

    public SpringDocUtils addRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(String ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils replaceWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceWithClass(source, target);
        return this;
    }

    public SpringDocUtils replaceWithSchema(Class source, Schema target) {
        AdditionalModelsConverter.replaceWithSchema(source, target);
        return this;
    }

    public SpringDocUtils addRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.addRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.removeRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFileType(Class<?> ... classes) {
        GenericParameterService.addFileType(classes);
        return this;
    }

    public SpringDocUtils addResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.addResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils addAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.addAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.removeAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.addSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils removeSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.removeSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils addSimpleTypePredicateForParameterObject(Predicate<Class<?>> predicate) {
        MethodParameterPojoExtractor.addSimpleTypePredicate(predicate);
        return this;
    }

    public SpringDocUtils disableReplacement(Class source) {
        AdditionalModelsConverter.disableReplacement(source);
        return this;
    }

    public SpringDocUtils replaceParameterObjectWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceParameterObjectWithClass(source, target);
        return this;
    }

    public SpringDocUtils setResponseEntityExceptionHandlerClass(Class<?> clazz) {
        GenericResponseService.setResponseEntityExceptionHandlerClass(clazz);
        return this;
    }

    public SpringDocUtils setModelAndViewClass(Class<?> clazz) {
        AbstractOpenApiResource.setModelAndViewClass(clazz);
        return this;
    }

    public SpringDocUtils removeFromSchemaMap(Class<?> clazz) {
        AdditionalModelsConverter.removeFromSchemaMap(clazz);
        return this;
    }

    public SpringDocUtils removeFromSchemaMap(Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            AdditionalModelsConverter.removeFromSchemaMap(aClass);
        }
        return this;
    }

    public SpringDocUtils removeFromSchemaClass(Class<?> clazz) {
        AdditionalModelsConverter.removeFromClassMap(clazz);
        return this;
    }

    public SpringDocUtils addJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.addJavaTypeToIgnore(clazz);
        return this;
    }

    public SpringDocUtils removeJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.removeJavaTypeToIgnore(clazz);
        return this;
    }

    public static boolean isValidPath(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && !path.equals("/");
    }

    public SpringDocUtils addParentType(String ... parentTypes) {
        PolymorphicModelConverter.addParentType(parentTypes);
        return this;
    }

    @NotNull
    public static Annotation[] getParameterAnnotations(MethodParameter methodParameter) {
        Object[] annotations = methodParameter.getParameterAnnotations();
        if (ArrayUtils.isEmpty((Object[])annotations)) {
            return new Annotation[0];
        }
        ArrayList<Object> resultAnnotations = new ArrayList<Object>(annotations.length);
        resultAnnotations.addAll(List.of(annotations));
        for (Object annotation : annotations) {
            Object[] metaAnnotations = annotation.annotationType().getAnnotations();
            if (!ArrayUtils.isNotEmpty((Object[])metaAnnotations)) continue;
            resultAnnotations.addAll(List.of(metaAnnotations));
        }
        return resultAnnotations.toArray(new Annotation[0]);
    }

    @NotNull
    public static String getParentTypeName(AnnotatedType type, Class<?> cls) {
        return cls.getSimpleName() + StringUtils.capitalize((String)(type.getParent().getType() != null ? type.getParent().getType() : "object"));
    }

    public static boolean isComposedSchema(Schema referencedSchema) {
        return referencedSchema.getOneOf() != null || referencedSchema.getAllOf() != null || referencedSchema.getAnyOf() != null;
    }

    public static void handleSchemaTypes(Schema<?> schema) {
        if (schema != null) {
            if (schema.getType() != null && CollectionUtils.isEmpty((Collection)schema.getTypes())) {
                schema.addType(schema.getType());
            } else if (schema.getItems() != null && schema.getItems().getType() != null && CollectionUtils.isEmpty((Collection)schema.getItems().getTypes())) {
                schema.getItems().addType(schema.getItems().getType());
            }
            if (schema.getProperties() != null) {
                schema.getProperties().forEach((key, value) -> SpringDocUtils.handleSchemaTypes(value));
            }
        }
    }

    public static void handleSchemaTypes(Content content) {
        if (content != null) {
            content.values().forEach(mediaType -> {
                if (mediaType.getSchema() != null) {
                    SpringDocUtils.handleSchemaTypes(mediaType.getSchema());
                }
            });
        }
    }

    public SpringDocUtils initExtraSchemas() {
        this.replaceWithSchema(LocalTime.class, new StringSchema().example((Object)"14:30:00"));
        this.replaceWithSchema(YearMonth.class, new StringSchema().example((Object)"2025-03"));
        this.replaceWithSchema(MonthDay.class, new StringSchema().example((Object)"--03-22"));
        this.replaceWithSchema(Year.class, new StringSchema().example((Object)"2025"));
        this.replaceWithSchema(Duration.class, new StringSchema().example((Object)"PT2H30M"));
        this.replaceWithSchema(Period.class, new StringSchema().example((Object)"P2Y3M"));
        this.replaceWithSchema(OffsetTime.class, new StringSchema().example((Object)"14:30:00+01:00"));
        this.replaceWithSchema(ZoneId.class, new StringSchema().example((Object)"Europe/Paris"));
        this.replaceWithSchema(ZoneOffset.class, new StringSchema().example((Object)"+01:00"));
        this.replaceWithSchema(TimeZone.class, new StringSchema().example((Object)"GMT"));
        this.replaceWithSchema(Charset.class, new StringSchema().example((Object)"UTF-8"));
        this.replaceWithSchema(Locale.class, new StringSchema().example((Object)"en-US"));
        return this;
    }

    public SpringDocUtils resetExtraSchemas() {
        SpringDocUtils.getConfig().removeFromSchemaMap(LocalTime.class, YearMonth.class, MonthDay.class, Year.class, Duration.class, Period.class, OffsetTime.class, ZoneId.class, ZoneOffset.class, TimeZone.class, Charset.class, Locale.class);
        return this;
    }
}

