/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springdoc.core.providers.ObjectMapperProvider;

public class PolymorphicModelConverter
implements ModelConverter {
    private final ObjectMapperProvider springDocObjectMapper;
    private static final List<String> PARENT_TYPES_TO_IGNORE = Collections.synchronizedList(new ArrayList());
    private static final List<String> TYPES_TO_SKIP = Collections.synchronizedList(new ArrayList());

    public PolymorphicModelConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public static void addParentType(String ... parentTypes) {
        PARENT_TYPES_TO_IGNORE.addAll(List.of(parentTypes));
    }

    private io.swagger.v3.oas.models.media.Schema<?> getResolvedSchema(JavaType javaType, io.swagger.v3.oas.models.media.Schema<?> resolvedSchema) {
        if (resolvedSchema instanceof ObjectSchema && resolvedSchema.getProperties() != null) {
            if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getName())) {
                resolvedSchema = (io.swagger.v3.oas.models.media.Schema)resolvedSchema.getProperties().get(javaType.getRawClass().getName());
            } else if (resolvedSchema.getProperties().containsKey(javaType.getRawClass().getSimpleName())) {
                resolvedSchema = (io.swagger.v3.oas.models.media.Schema)resolvedSchema.getProperties().get(javaType.getRawClass().getSimpleName());
            }
        }
        return resolvedSchema;
    }

    public io.swagger.v3.oas.models.media.Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null) {
            for (Field field : FieldUtils.getAllFields((Class)javaType.getRawClass())) {
                Schema declaredSchema;
                if (field.isAnnotationPresent(JsonUnwrapped.class)) {
                    PARENT_TYPES_TO_IGNORE.add(javaType.getRawClass().getSimpleName());
                    continue;
                }
                if (!field.isAnnotationPresent(Schema.class) || !ArrayUtils.isNotEmpty((Object[])(declaredSchema = field.getDeclaredAnnotation(Schema.class)).oneOf()) && !ArrayUtils.isNotEmpty((Object[])declaredSchema.allOf())) continue;
                TYPES_TO_SKIP.add(field.getType().getSimpleName());
            }
            if (chain.hasNext()) {
                if (!type.isResolveAsRef() && type.getParent() != null && PARENT_TYPES_TO_IGNORE.stream().noneMatch(ignore -> type.getParent().getName().startsWith((String)ignore))) {
                    type.resolveAsRef(true);
                }
                io.swagger.v3.oas.models.media.Schema<?> resolvedSchema = chain.next().resolve(type, context, chain);
                if ((resolvedSchema = this.getResolvedSchema(javaType, resolvedSchema)) == null || resolvedSchema.get$ref() == null) {
                    return resolvedSchema;
                }
                if (resolvedSchema.get$ref().contains("#/components/schemas/")) {
                    String schemaName = resolvedSchema.get$ref().substring("#/components/schemas/".length());
                    io.swagger.v3.oas.models.media.Schema existingSchema = (io.swagger.v3.oas.models.media.Schema)context.getDefinedModels().get(schemaName);
                    if (existingSchema != null && (existingSchema.getOneOf() != null || existingSchema.getAllOf() != null)) {
                        return resolvedSchema;
                    }
                }
                return this.composePolymorphicSchema(type, resolvedSchema, context.getDefinedModels().values());
            }
        }
        return null;
    }

    private io.swagger.v3.oas.models.media.Schema composePolymorphicSchema(AnnotatedType type, io.swagger.v3.oas.models.media.Schema schema, Collection<io.swagger.v3.oas.models.media.Schema> schemas) {
        String ref = schema.get$ref();
        List<io.swagger.v3.oas.models.media.Schema> composedSchemas = this.findComposedSchemas(ref, schemas);
        if (composedSchemas.isEmpty()) {
            return schema;
        }
        ComposedSchema result = new ComposedSchema();
        if (this.isConcreteClass(type)) {
            result.addOneOfItem(schema);
        }
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        Class clazz = javaType.getRawClass();
        if (TYPES_TO_SKIP.stream().noneMatch(typeToSkip -> typeToSkip.equals(clazz.getSimpleName()))) {
            composedSchemas.forEach(arg_0 -> ((ComposedSchema)result).addOneOfItem(arg_0));
        }
        return result;
    }

    private List<io.swagger.v3.oas.models.media.Schema> findComposedSchemas(String ref, Collection<io.swagger.v3.oas.models.media.Schema> schemas) {
        List<io.swagger.v3.oas.models.media.Schema> composedSchemas = schemas.stream().filter(ComposedSchema.class::isInstance).map(ComposedSchema.class::cast).filter(s -> s.getAllOf() != null).filter(s -> s.getAllOf().stream().anyMatch(s2 -> ref.equals(s2.get$ref()))).map(s -> new io.swagger.v3.oas.models.media.Schema().$ref("#/components/schemas/" + s.getName())).toList();
        ArrayList<io.swagger.v3.oas.models.media.Schema> resultSchemas = new ArrayList<io.swagger.v3.oas.models.media.Schema>(composedSchemas);
        for (io.swagger.v3.oas.models.media.Schema childSchema : composedSchemas) {
            String childSchemaRef = childSchema.get$ref();
            resultSchemas.addAll(this.findComposedSchemas(childSchemaRef, schemas));
        }
        return resultSchemas;
    }

    private boolean isConcreteClass(AnnotatedType type) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        Class clazz = javaType.getRawClass();
        return !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface();
    }

    static {
        PARENT_TYPES_TO_IGNORE.add("JsonSchema");
        PARENT_TYPES_TO_IGNORE.add("Pageable");
        PARENT_TYPES_TO_IGNORE.add("EntityModel");
    }
}

