/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.converters.SortOpenAPIConverter;
import org.springdoc.core.converters.models.SortObject;
import org.springdoc.core.customizers.DataRestDelegatingMethodParameterCustomizer;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.RepositoryRestConfigurationProvider;
import org.springdoc.core.providers.SpringDataWebPropertiesProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Sort.class})
@ConditionalOnWebApplication
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocSortConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.sort-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    SortOpenAPIConverter sortOpenAPIConverter(ObjectMapperProvider objectMapperProvider) {
        SpringDocUtils.getConfig().replaceParameterObjectWithClass(Sort.class, org.springdoc.core.converters.models.Sort.class);
        SpringDocUtils.getConfig().replaceWithClass(Sort.class, SortObject.class);
        return new SortOpenAPIConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    DelegatingMethodParameterCustomizer delegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfiguration) {
        return new DataRestDelegatingMethodParameterCustomizer(optionalSpringDataWebPropertiesProvider, optionalRepositoryRestConfiguration);
    }
}

