/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.CollectionUtils;

public class SpecificationStringPropertiesCustomizer
implements GlobalOpenApiCustomizer {
    private static final String SPECIFICATION_STRINGS_PREFIX = "springdoc.specification-strings.";
    private final PropertyResolver propertyResolver;
    private final String propertyPrefix;

    public SpecificationStringPropertiesCustomizer(PropertyResolver resolverUtils) {
        this.propertyResolver = resolverUtils;
        this.propertyPrefix = SPECIFICATION_STRINGS_PREFIX;
    }

    public SpecificationStringPropertiesCustomizer(PropertyResolver propertyResolver, String groupName) {
        this.propertyResolver = propertyResolver;
        this.propertyPrefix = SPECIFICATION_STRINGS_PREFIX + groupName + ".";
    }

    @Override
    public void customise(OpenAPI openApi) {
        this.setOperationInfoProperties(openApi);
        this.setComponentsProperties(openApi);
        this.setPathsProperties(openApi);
    }

    private void setOperationInfoProperties(OpenAPI openApi) {
        if (openApi.getInfo() == null) {
            openApi.setInfo(new Info());
        }
        Info info = openApi.getInfo();
        this.resolveString(arg_0 -> ((Info)info).setTitle(arg_0), "info.title");
        this.resolveString(arg_0 -> ((Info)info).setDescription(arg_0), "info.description");
        this.resolveString(arg_0 -> ((Info)info).setVersion(arg_0), "info.version");
        this.resolveString(arg_0 -> ((Info)info).setTermsOfService(arg_0), "info.termsOfService");
    }

    private void setPathsProperties(OpenAPI openApi) {
        Paths paths = openApi.getPaths();
        if (CollectionUtils.isEmpty((Collection)paths.values())) {
            return;
        }
        for (PathItem pathItem : paths.values()) {
            List operations = pathItem.readOperations();
            for (Operation operation : operations) {
                String operationId = operation.getOperationId();
                String operationNode = MessageFormat.format("paths.{0}", operationId);
                this.resolveString(arg_0 -> ((Operation)operation).setDescription(arg_0), operationNode + ".description");
                this.resolveString(arg_0 -> ((Operation)operation).setSummary(arg_0), operationNode + ".summary");
            }
        }
    }

    private void setComponentsProperties(OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null || CollectionUtils.isEmpty((Map)components.getSchemas())) {
            return;
        }
        for (Schema componentSchema : components.getSchemas().values()) {
            String schemaPropertyPrefix = MessageFormat.format("components.schemas.{0}", componentSchema.getName());
            this.resolveString(arg_0 -> ((Schema)componentSchema).setDescription(arg_0), schemaPropertyPrefix + ".description");
            Map properties = componentSchema.getProperties();
            if (CollectionUtils.isEmpty((Map)properties)) continue;
            for (Schema propSchema : properties.values()) {
                String propertyNode = MessageFormat.format("components.schemas.{0}.properties.{1}", componentSchema.getName(), propSchema.getName());
                this.resolveString(arg_0 -> ((Schema)propSchema).setDescription(arg_0), propertyNode + ".description");
                this.resolveString(arg_0 -> ((Schema)propSchema).setExample(arg_0), propertyNode + ".example");
            }
        }
    }

    private void resolveString(Consumer<String> setter, String node) {
        String nodeWithPrefix = this.propertyPrefix + node;
        String value = this.propertyResolver.getProperty(nodeWithPrefix);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            setter.accept(value);
        }
    }
}

