/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springdoc.core.fn.RouterFunctionData;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;

public class AbstractRouterFunctionVisitor {
    private final List<String> consumes = new ArrayList<String>();
    private final List<String> produces = new ArrayList<String>();
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>();
    protected List<RouterFunctionData> routerFunctionDatas = new ArrayList<RouterFunctionData>();
    protected List<String> orPaths = new ArrayList<String>();
    protected Map<Integer, List<String>> nestedPaths = new LinkedHashMap<Integer, List<String>>();
    protected boolean isOr;
    protected List<RouterFunctionData> currentRouterFunctionDatas;
    protected Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private int level;
    private Set<HttpMethod> methods;

    public void method(Set<HttpMethod> methods) {
        if (CollectionUtils.isEmpty(this.currentRouterFunctionDatas)) {
            this.methods = methods;
        } else {
            this.currentRouterFunctionDatas.forEach(routerFunctionData -> routerFunctionData.setMethods(methods));
        }
    }

    public void path(String pattern) {
        if (this.currentRouterFunctionDatas != null) {
            if (!this.nestedPaths.isEmpty()) {
                List nestedPathsList = this.nestedPaths.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                if (!this.orPaths.isEmpty()) {
                    this.orPaths.forEach(nestedOrPath -> this.createRouterFunctionData(String.join((CharSequence)"", nestedPathsList) + nestedOrPath + pattern));
                } else {
                    this.createRouterFunctionData(String.join((CharSequence)"", nestedPathsList) + pattern);
                }
            } else if (!this.orPaths.isEmpty()) {
                this.orPaths.forEach(nestedOrPath -> this.createRouterFunctionData(nestedOrPath + pattern));
            } else {
                this.createRouterFunctionData(pattern);
            }
        } else if (this.isOr) {
            this.orPaths.add(pattern);
        } else if (this.level > 0) {
            ArrayList<String> paths = CollectionUtils.isEmpty((Collection)this.nestedPaths.get(this.level)) ? new ArrayList<String>() : this.nestedPaths.get(this.level);
            paths.add(pattern);
            this.nestedPaths.put(this.level, paths);
        }
    }

    public void header(String name, String value) {
        if ("Accept".equals(name)) {
            this.calculateHeader(value, this.produces, name);
        } else if ("Content-Type".equals(name)) {
            this.calculateHeader(value, this.consumes, name);
        } else {
            this.currentRouterFunctionDatas.forEach(routerFunctionData -> routerFunctionData.addHeaders(name + "=" + value));
        }
    }

    public List<RouterFunctionData> getRouterFunctionDatas() {
        return this.routerFunctionDatas;
    }

    public void queryParam(String name, String value) {
        if (CollectionUtils.isEmpty(this.currentRouterFunctionDatas)) {
            this.queryParams.put(name, value);
        } else {
            this.currentRouterFunctionDatas.forEach(routerFunctionData -> routerFunctionData.addQueryParams(name, value));
        }
    }

    public void pathExtension(String extension) {
    }

    public void param(String name, String value) {
    }

    public void startAnd() {
    }

    public void and() {
    }

    public void endAnd() {
    }

    public void startOr() {
        this.isOr = true;
    }

    public void or() {
    }

    public void endOr() {
        this.isOr = false;
    }

    public void startNegate() {
    }

    public void endNegate() {
    }

    public void attributes(Map<String, Object> map) {
        this.attributes = map;
    }

    protected void commonEndNested() {
        this.nestedPaths.remove(this.level);
        --this.level;
    }

    protected void commonStartNested() {
        ++this.level;
        this.currentRouterFunctionDatas = null;
    }

    protected void commonRoute() {
        this.routerFunctionDatas.addAll(this.currentRouterFunctionDatas);
        this.currentRouterFunctionDatas.forEach(routerFunctionData -> routerFunctionData.addAttributes(this.attributes));
        this.attributes = new HashMap<String, Object>();
    }

    private void calculateHeader(String value, List<String> headers, String header) {
        if (value.contains(",")) {
            String[] mediaTypes;
            for (String mediaType : mediaTypes = value.substring(1, value.length() - 1).split(", ")) {
                if (CollectionUtils.isEmpty(this.currentRouterFunctionDatas)) {
                    headers.add(mediaType);
                    continue;
                }
                this.currentRouterFunctionDatas.forEach(routerFunctionData -> this.addHeader(mediaType, header, (RouterFunctionData)routerFunctionData));
            }
        } else if (CollectionUtils.isEmpty(this.currentRouterFunctionDatas)) {
            headers.add(value);
        } else {
            this.currentRouterFunctionDatas.forEach(routerFunctionData -> this.addHeader(value, header, (RouterFunctionData)routerFunctionData));
        }
    }

    private void createRouterFunctionData(String path) {
        RouterFunctionData routerFunctionData = new RouterFunctionData();
        routerFunctionData.setPath(path);
        routerFunctionData.setMethods(this.methods);
        routerFunctionData.addConsumes(this.consumes);
        routerFunctionData.addProduces(this.produces);
        this.queryParams.forEach(routerFunctionData::addQueryParams);
        this.currentRouterFunctionDatas.add(routerFunctionData);
    }

    private void addHeader(String mediaType, String header, RouterFunctionData routerFunctionData) {
        if ("Content-Type".equals(header)) {
            routerFunctionData.addConsumes(mediaType);
        } else if ("Accept".equals(header)) {
            routerFunctionData.addProduces(mediaType);
        }
    }
}

