/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.ControllerAdviceInfo;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;

public class GenericResponseService {
    private static final String EXTENSION_EXCEPTION_CLASSES = "x-exception-class";
    private static Class<?> responseEntityExceptionHandlerClass;
    private final OperationService operationService;
    private final List<ReturnTypeParser> returnTypeParsers;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final PropertyResolverUtils propertyResolverUtils;
    private final List<ControllerAdviceInfo> localExceptionHandlers = new ArrayList<ControllerAdviceInfo>();
    private final List<ControllerAdviceInfo> controllerAdviceInfos = new ArrayList<ControllerAdviceInfo>();
    private static final Logger LOGGER;

    public GenericResponseService(OperationService operationService, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        this.operationService = operationService;
        this.returnTypeParsers = returnTypeParsers;
        this.springDocConfigProperties = springDocConfigProperties;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public static void buildContentFromDoc(Components components, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations, ApiResponse apiResponse) {
        io.swagger.v3.oas.annotations.media.Content[] contentdoc = apiResponseAnnotations.content();
        Optional<Content> optionalContent = SpringDocAnnotationsUtils.getContent(contentdoc, new String[0], methodAttributes.getMethodProduces(), null, components, methodAttributes.getJsonViewAnnotation());
        if (apiResponsesOp.containsKey((Object)apiResponseAnnotations.responseCode())) {
            Content existingContent = ((ApiResponse)apiResponsesOp.get((Object)apiResponseAnnotations.responseCode())).getContent();
            if (optionalContent.isPresent()) {
                Content newContent = optionalContent.get();
                if (methodAttributes.isMethodOverloaded() && existingContent != null) {
                    Arrays.stream(methodAttributes.getMethodProduces()).filter(mediaTypeStr -> newContent.get(mediaTypeStr) != null).forEach(mediaTypeStr -> {
                        if (((MediaType)newContent.get(mediaTypeStr)).getSchema() != null) {
                            SpringDocAnnotationsUtils.mergeSchema(existingContent, ((MediaType)newContent.get(mediaTypeStr)).getSchema(), mediaTypeStr);
                        }
                    });
                    apiResponse.content(existingContent);
                } else {
                    apiResponse.content(newContent);
                }
            } else {
                apiResponse.content(existingContent);
            }
        } else {
            optionalContent.ifPresent(arg_0 -> ((ApiResponse)apiResponse).content(arg_0));
        }
    }

    public static void setDescription(String httpCode, ApiResponse apiResponse) {
        try {
            HttpStatus httpStatus = HttpStatus.valueOf((int)Integer.parseInt(httpCode));
            apiResponse.setDescription(httpStatus.getReasonPhrase());
        }
        catch (IllegalArgumentException e) {
            apiResponse.setDescription("default response");
        }
    }

    public static void setResponseEntityExceptionHandlerClass(Class<?> responseEntityExceptionHandlerClass) {
        GenericResponseService.responseEntityExceptionHandlerClass = responseEntityExceptionHandlerClass;
    }

    public io.swagger.v3.oas.models.responses.ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, MethodAttributes methodAttributes) {
        Map<String, ApiResponse> genericMapResponse = this.getGenericMapResponse(handlerMethod.getBeanType());
        if (this.springDocConfigProperties.isOverrideWithGenericResponse()) {
            genericMapResponse = this.filterAndEnrichGenericMapResponseByDeclarations(handlerMethod, genericMapResponse);
        }
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = methodAttributes.calculateGenericMapResponse(genericMapResponse);
        io.swagger.v3.oas.models.responses.ApiResponses apiResponsesFromDoc = operation.getResponses();
        if (!CollectionUtils.isEmpty((Map)apiResponsesFromDoc)) {
            apiResponsesFromDoc.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.responses.ApiResponses)apiResponses).addApiResponse(arg_0, arg_1));
        }
        this.computeResponseFromDoc(components, handlerMethod.getReturnType(), apiResponses, methodAttributes);
        this.buildApiResponses(components, handlerMethod.getReturnType(), apiResponses, methodAttributes);
        return apiResponses;
    }

    private Map<String, ApiResponse> filterAndEnrichGenericMapResponseByDeclarations(HandlerMethod handlerMethod, Map<String, ApiResponse> genericMapResponse) {
        if (this.operationService.getJavadocProvider() != null) {
            JavadocProvider javadocProvider = this.operationService.getJavadocProvider();
            for (Map.Entry<String, ApiResponse> genericResponse : genericMapResponse.entrySet()) {
                Map extensions = genericResponse.getValue().getExtensions();
                Collection genericExceptions = (Collection)extensions.get(EXTENSION_EXCEPTION_CLASSES);
                for (Class<?> declaredException : handlerMethod.getMethod().getExceptionTypes()) {
                    if (!genericExceptions.contains(declaredException.getName())) continue;
                    Map<String, String> javadocThrows = javadocProvider.getMethodJavadocThrows(handlerMethod.getMethod());
                    String description = javadocThrows.get(declaredException.getName());
                    if (description == null) {
                        description = javadocThrows.get(declaredException.getSimpleName());
                    }
                    if (description == null || description.trim().isEmpty()) continue;
                    genericResponse.getValue().setDescription(description);
                }
            }
        }
        return genericMapResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildGenericResponse(Components components, Map<String, Object> findControllerAdvice, Locale locale) {
        for (Map.Entry<String, Object> entry : findControllerAdvice.entrySet()) {
            ArrayList methods = new ArrayList();
            Object controllerAdvice = entry.getValue();
            Class objClz = controllerAdvice.getClass();
            if (AopUtils.isAopProxy((Object)controllerAdvice)) {
                objClz = AopUtils.getTargetClass((Object)controllerAdvice);
            }
            ControllerAdviceInfo controllerAdviceInfo = new ControllerAdviceInfo(controllerAdvice);
            Arrays.stream(ReflectionUtils.getAllDeclaredMethods((Class)objClz)).filter(m -> m.isAnnotationPresent(ExceptionHandler.class) || this.isResponseEntityExceptionHandlerMethod((Method)m)).forEach(methods::add);
            for (Method method : methods) {
                if (this.operationService.isHidden(method)) continue;
                RequestMapping reqMappingMethod = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
                String[] methodProduces = new String[]{this.springDocConfigProperties.getDefaultProducesMediaType()};
                if (reqMappingMethod != null) {
                    methodProduces = reqMappingMethod.produces();
                }
                Map<String, ApiResponse> controllerAdviceInfoApiResponseMap = controllerAdviceInfo.getApiResponseMap();
                MethodParameter methodParameter = new MethodParameter(method, -1);
                io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp = new io.swagger.v3.oas.models.responses.ApiResponses();
                MethodAttributes methodAttributes = new MethodAttributes(methodProduces, this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), controllerAdviceInfoApiResponseMap, locale);
                methodAttributes.setJsonViewAnnotation((JsonView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, JsonView.class));
                if (this.operationService.getJavadocProvider() != null) {
                    JavadocProvider javadocProvider = this.operationService.getJavadocProvider();
                    methodAttributes.setJavadocReturn(javadocProvider.getMethodJavadocReturn(methodParameter.getMethod()));
                }
                Map<String, ApiResponse> apiResponses = this.computeResponseFromDoc(components, methodParameter, apiResponsesOp, methodAttributes);
                this.buildGenericApiResponses(components, methodParameter, apiResponsesOp, methodAttributes);
                apiResponses.forEach(controllerAdviceInfoApiResponseMap::put);
            }
            GenericResponseService genericResponseService = this;
            synchronized (genericResponseService) {
                if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)objClz, ControllerAdvice.class)) {
                    this.controllerAdviceInfos.add(controllerAdviceInfo);
                } else {
                    this.localExceptionHandlers.add(controllerAdviceInfo);
                }
            }
        }
    }

    private boolean isResponseEntityExceptionHandlerMethod(Method m) {
        if (AnnotatedElementUtils.hasAnnotation(m.getDeclaringClass(), ControllerAdvice.class)) {
            return responseEntityExceptionHandlerClass != null && responseEntityExceptionHandlerClass.isAssignableFrom(m.getDeclaringClass()) && ReflectionUtils.findMethod(responseEntityExceptionHandlerClass, (String)m.getName(), (Class[])m.getParameterTypes()) != null;
        }
        return false;
    }

    private Map<String, ApiResponse> computeResponseFromDoc(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes) {
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responsesArray = this.getApiResponses(Objects.requireNonNull(methodParameter.getMethod()));
        if (!responsesArray.isEmpty()) {
            methodAttributes.setWithApiResponseDoc(true);
            for (io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations : responsesArray) {
                String httpCode = apiResponseAnnotations.responseCode();
                ApiResponse apiResponse = new ApiResponse();
                if (StringUtils.isNotBlank((CharSequence)apiResponseAnnotations.ref())) {
                    apiResponse.$ref(apiResponseAnnotations.ref());
                    apiResponsesOp.addApiResponse(apiResponseAnnotations.responseCode(), apiResponse);
                    continue;
                }
                apiResponse.setDescription(this.propertyResolverUtils.resolve(apiResponseAnnotations.description(), methodAttributes.getLocale()));
                GenericResponseService.buildContentFromDoc(components, apiResponsesOp, methodAttributes, apiResponseAnnotations, apiResponse);
                Map extensions = AnnotationsUtils.getExtensions((Extension[])apiResponseAnnotations.extensions());
                if (!CollectionUtils.isEmpty((Map)extensions)) {
                    apiResponse.extensions(extensions);
                }
                AnnotationsUtils.getHeaders((Header[])apiResponseAnnotations.headers(), (JsonView)methodAttributes.getJsonViewAnnotation()).ifPresent(arg_0 -> ((ApiResponse)apiResponse).headers(arg_0));
                apiResponsesOp.addApiResponse(httpCode, apiResponse);
            }
        }
        return apiResponsesOp;
    }

    private void buildGenericApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes) {
        if (!CollectionUtils.isEmpty((Map)apiResponsesOp)) {
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                String httpCode = (String)entry.getKey();
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, true);
            }
        } else {
            String httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), true);
            if (Objects.nonNull(httpCode)) {
                ApiResponse apiResponse = methodAttributes.getGenericMapResponse().containsKey(httpCode) ? methodAttributes.getGenericMapResponse().get(httpCode) : new ApiResponse();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, true);
            }
        }
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes) {
        Map<String, ApiResponse> genericMapResponse = methodAttributes.getGenericMapResponse();
        if (!CollectionUtils.isEmpty((Map)apiResponsesOp) && apiResponsesOp.size() > genericMapResponse.size()) {
            String httpCode;
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                boolean methodAttributesCondition;
                String httpCode2 = (String)entry.getKey();
                boolean bl = methodAttributesCondition = !methodAttributes.isMethodOverloaded() || methodAttributes.isMethodOverloaded() && this.isValidHttpCode(httpCode2, methodParameter);
                if (genericMapResponse.containsKey(httpCode2) || !methodAttributesCondition) continue;
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode2, apiResponse, false);
            }
            if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)methodParameter.getMethod(), ResponseStatus.class) && Objects.nonNull(httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), false)) && !apiResponsesOp.containsKey((Object)httpCode) && !apiResponsesOp.containsKey((Object)"default")) {
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, new ApiResponse(), false);
            }
        } else {
            String httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), false);
            if (Objects.nonNull(httpCode)) {
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, new ApiResponse(), false);
            }
        }
    }

    public Set<io.swagger.v3.oas.annotations.responses.ApiResponse> getApiResponses(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiResponsesDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, ApiResponses.class);
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responses = apiResponsesDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        Set apiResponsesDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, ApiResponses.class);
        responses.addAll(apiResponsesDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet()));
        Set apiResponseDoc = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDoc);
        Set apiResponseDocDeclaringClass = AnnotatedElementUtils.findMergedRepeatableAnnotations(declaringClass, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDocDeclaringClass);
        return responses;
    }

    private Content buildContent(Components components, MethodParameter methodParameter, String[] methodProduces, JsonView jsonView) {
        Type returnType = this.getReturnType(methodParameter);
        return this.buildContent(components, methodParameter.getParameterAnnotations(), methodProduces, jsonView, returnType);
    }

    public Content buildContent(Components components, Annotation[] annotations, String[] methodProduces, JsonView jsonView, Type returnType) {
        Schema<?> schemaN;
        Content content = new Content();
        if (this.isVoid(returnType)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])methodProduces) && (schemaN = this.calculateSchema(components, returnType, jsonView, annotations)) != null) {
            MediaType mediaType = new MediaType();
            mediaType.setSchema(schemaN);
            this.setContent(methodProduces, content, mediaType);
        }
        return content;
    }

    private Type getReturnType(MethodParameter methodParameter) {
        Object returnType = Object.class;
        for (ReturnTypeParser returnTypeParser : this.returnTypeParsers) {
            if (!returnType.getTypeName().equals(Object.class.getTypeName())) break;
            returnType = returnTypeParser.getReturnType(methodParameter);
        }
        return returnType;
    }

    private Schema<?> calculateSchema(Components components, Type returnType, JsonView jsonView, Annotation[] annotations) {
        if (!this.isVoid(returnType) && !SpringDocAnnotationsUtils.isAnnotationToIgnore(returnType)) {
            return SpringDocAnnotationsUtils.extractSchema(components, returnType, jsonView, annotations);
        }
        return null;
    }

    private void setContent(String[] methodProduces, Content content, MediaType mediaType) {
        Arrays.stream(methodProduces).forEach(mediaTypeStr -> content.addMediaType(mediaTypeStr, mediaType));
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, String httpCode, ApiResponse apiResponse, boolean isGeneric) {
        if (StringUtils.isBlank((CharSequence)apiResponse.get$ref())) {
            if (apiResponse.getContent() == null) {
                Content content = this.buildContent(components, methodParameter, methodAttributes.getMethodProduces(), methodAttributes.getJsonViewAnnotation());
                apiResponse.setContent(content);
            } else if (CollectionUtils.isEmpty((Map)apiResponse.getContent())) {
                apiResponse.setContent(null);
            }
            if (StringUtils.isBlank((CharSequence)apiResponse.getDescription())) {
                if (!StringUtils.isBlank((CharSequence)methodAttributes.getJavadocReturn())) {
                    apiResponse.setDescription(methodAttributes.getJavadocReturn());
                } else {
                    GenericResponseService.setDescription(httpCode, apiResponse);
                }
            }
        }
        if (apiResponse.getContent() != null && (isGeneric || methodAttributes.isMethodOverloaded()) && methodAttributes.isNoApiResponseDoc()) {
            Content existingContent = apiResponse.getContent();
            Type type = ReturnTypeParser.getType(methodParameter);
            Schema<?> schemaN = this.calculateSchema(components, type, methodAttributes.getJsonViewAnnotation(), methodParameter.getParameterAnnotations());
            if (schemaN != null && ArrayUtils.isNotEmpty((Object[])methodAttributes.getMethodProduces())) {
                Arrays.stream(methodAttributes.getMethodProduces()).forEach(mediaTypeStr -> SpringDocAnnotationsUtils.mergeSchema(existingContent, schemaN, mediaTypeStr));
            }
        }
        if (this.springDocConfigProperties.isOverrideWithGenericResponse() && methodParameter.getExecutable().isAnnotationPresent(ExceptionHandler.class)) {
            ExceptionHandler exceptionHandler = methodParameter.getExecutable().getAnnotation(ExceptionHandler.class);
            HashSet<Class> exceptions = new HashSet<Class>();
            if (exceptionHandler.value().length == 0) {
                for (Parameter parameter : methodParameter.getExecutable().getParameters()) {
                    if (!Throwable.class.isAssignableFrom(parameter.getType())) continue;
                    exceptions.add(parameter.getType());
                }
            } else {
                exceptions.addAll(Arrays.asList(exceptionHandler.value()));
            }
            apiResponse.addExtension(EXTENSION_EXCEPTION_CLASSES, exceptions);
        }
        apiResponsesOp.addApiResponse(httpCode, apiResponse);
    }

    public String evaluateResponseStatus(Method method, Class<?> beanType, boolean isGeneric) {
        String responseStatus = null;
        ResponseStatus annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResponseStatus.class);
        if (annotation == null && beanType != null) {
            annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(beanType, ResponseStatus.class);
        }
        if (annotation != null) {
            responseStatus = String.valueOf(annotation.code().value());
        }
        if (annotation == null && !isGeneric) {
            responseStatus = String.valueOf(HttpStatus.OK.value());
        }
        return responseStatus;
    }

    private boolean isVoid(Type returnType) {
        Type[] types;
        boolean result = false;
        if (Void.TYPE.equals(returnType) || Void.class.equals((Object)returnType)) {
            result = true;
        } else if (returnType instanceof ParameterizedType && (types = ((ParameterizedType)returnType).getActualTypeArguments()) != null && ConverterUtils.isResponseTypeWrapper(ResolvableType.forType((Type)returnType).getRawClass())) {
            result = this.isVoid(types[0]);
        }
        return result;
    }

    private synchronized Map<String, ApiResponse> getGenericMapResponse(Class<?> beanType) {
        List controllerAdviceInfosInThisBean = this.localExceptionHandlers.stream().filter(controllerInfo -> beanType.equals(controllerInfo.getControllerAdvice().getClass())).collect(Collectors.toList());
        Map genericApiResponseMap = controllerAdviceInfosInThisBean.stream().map(ControllerAdviceInfo::getApiResponseMap).collect(LinkedHashMap::new, Map::putAll, Map::putAll);
        List controllerAdviceInfosNotInThisBean = this.controllerAdviceInfos.stream().filter(controllerAdviceInfo -> new ControllerAdviceBean(controllerAdviceInfo.getControllerAdvice()).isApplicableToBeanType(beanType)).collect(Collectors.toList());
        for (ControllerAdviceInfo controllerAdviceInfo2 : controllerAdviceInfosNotInThisBean) {
            controllerAdviceInfo2.getApiResponseMap().forEach((key, apiResponse) -> {
                if (!genericApiResponseMap.containsKey(key)) {
                    genericApiResponseMap.put(key, apiResponse);
                }
            });
        }
        try {
            ObjectMapper objectMapper = ObjectMapperProvider.createJson(this.springDocConfigProperties);
            LinkedHashMap genericApiResponsesClone = (LinkedHashMap)objectMapper.readValue(objectMapper.writeValueAsString((Object)genericApiResponseMap), io.swagger.v3.oas.models.responses.ApiResponses.class);
            return genericApiResponsesClone;
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Json Processing Exception occurred: {}", (Object)e.getMessage());
            return genericApiResponseMap;
        }
    }

    private boolean isValidHttpCode(String httpCode, MethodParameter methodParameter) {
        boolean result = false;
        Method method = methodParameter.getMethod();
        if (method != null) {
            Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responseSet = this.getApiResponses(method);
            if (this.isHttpCodePresent(httpCode, responseSet)) {
                result = true;
            } else {
                io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, io.swagger.v3.oas.annotations.Operation.class);
                if (apiOperation != null) {
                    responseSet = new HashSet<io.swagger.v3.oas.annotations.responses.ApiResponse>(Arrays.asList(apiOperation.responses()));
                    if (this.isHttpCodePresent(httpCode, responseSet)) {
                        result = true;
                    }
                } else if (httpCode.equals(this.evaluateResponseStatus(method, method.getClass(), false))) {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean isHttpCodePresent(String httpCode, Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responseSet) {
        return !responseSet.isEmpty() && responseSet.stream().anyMatch(apiResponseAnnotations -> httpCode.equals(apiResponseAnnotations.responseCode()));
    }

    static {
        LOGGER = LoggerFactory.getLogger(GenericResponseService.class);
    }
}

