/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser;

import com.bstek.ureport.cache.ResourceCache;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.value.Slash;
import com.bstek.ureport.definition.value.SlashValue;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.utils.UnitUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.springblade.core.tool.utils.Base64Util;

public class SlashBuilder {
    public void buildSlashImage(CellDefinition cell, ReportDefinition report) {
        int colNumberStart;
        String text;
        String text2;
        String text3;
        Slash slash;
        int i;
        int rowNumber = cell.getRowNumber();
        int colNumber = cell.getColumnNumber();
        int rowSpan = cell.getRowSpan();
        int colSpan = cell.getColSpan();
        int verticalBorderWidth = 0;
        int horizontalBorderWidth = 0;
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getLeftBorder() != null) {
            verticalBorderWidth += cellStyle.getLeftBorder().getWidth();
        }
        if (cellStyle.getRightBorder() != null) {
            verticalBorderWidth += cellStyle.getRightBorder().getWidth();
        }
        if (cellStyle.getTopBorder() != null) {
            horizontalBorderWidth = cellStyle.getTopBorder().getWidth();
        }
        if (cellStyle.getBottomBorder() != null) {
            horizontalBorderWidth = cellStyle.getBottomBorder().getWidth();
        }
        int width = 0;
        int height = 0;
        if (rowSpan == 0) {
            rowSpan = 1;
        }
        if (colSpan == 0) {
            colSpan = 1;
        }
        List columns = report.getColumns();
        List rows = report.getRows();
        for (i = colNumber; i < colNumber + colSpan; ++i) {
            ColumnDefinition col = (ColumnDefinition)columns.get(i - 1);
            width += UnitUtils.pointToPixel((double)col.getWidth());
        }
        for (i = rowNumber; i < rowNumber + rowSpan; ++i) {
            RowDefinition row = (RowDefinition)rows.get(i - 1);
            height += UnitUtils.pointToPixel((double)row.getHeight());
        }
        SlashValue content = (SlashValue)cell.getValue();
        BufferedImage image = new BufferedImage(width -= horizontalBorderWidth, height -= verticalBorderWidth, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Font font = cellStyle.getFont();
        g.setFont(font);
        g.setStroke(new BasicStroke(1.0f));
        String bgColor = cellStyle.getBgcolor();
        if (bgColor == null) {
            bgColor = "255,255,255";
        }
        g.setColor(this.getColor(bgColor));
        g.fillRect(0, 0, width, height);
        AffineTransform transform = g.getTransform();
        int allRowHeight = 0;
        int index = 0;
        String lc = cellStyle.getForecolor();
        if (lc == null) {
            lc = "0,0,0";
        }
        Color lineColor = this.getColor(lc);
        String fc = cellStyle.getForecolor();
        if (fc == null) {
            fc = "0,0,0";
        }
        Color fontColor = this.getColor(fc);
        for (int i2 = rowNumber; i2 < rowNumber + rowSpan && (slash = this.getSlash(content, index)) != null && (text3 = slash.getText()) != null; ++i2) {
            RowDefinition row = (RowDefinition)rows.get(i2 - 1);
            int rowHeight = UnitUtils.pointToPixel((double)row.getHeight());
            g.setColor(fontColor);
            int x = slash.getX();
            int y = slash.getY();
            g.rotate(Math.toRadians(slash.getDegree()), x, y);
            g.drawString(text3, x, y);
            g.setTransform(transform);
            g.setColor(lineColor);
            int h = allRowHeight + rowHeight;
            if (i2 == rowNumber + rowSpan - 1) {
                h = allRowHeight + rowHeight / 3 * 2;
            }
            g.drawLine(0, 0, width, h);
            allRowHeight += rowHeight;
            ++index;
        }
        Slash slash2 = this.getSlash(content, index);
        if (slash2 != null && (text2 = slash2.getText()) != null) {
            int x = slash2.getX();
            int y = slash2.getY();
            g.rotate(Math.toRadians(slash2.getDegree()), x, y);
            g.setColor(fontColor);
            g.drawString(text2, x, y);
            g.setTransform(transform);
            ++index;
        }
        if (colSpan > 0) {
            --colSpan;
        }
        for (int i3 = colNumberStart = colNumber + colSpan; i3 > colNumber - 1 && (slash2 = this.getSlash(content, index)) != null && (text = slash2.getText()) != null; --i3) {
            int x = slash2.getX();
            int y = slash2.getY();
            g.rotate(Math.toRadians(slash2.getDegree()), x, y);
            g.setColor(fontColor);
            g.drawString(text, x, y);
            g.setTransform(transform);
            ColumnDefinition col = (ColumnDefinition)columns.get(i3 - 1);
            int colWidth = UnitUtils.pointToPixel((double)col.getWidth());
            int w = width;
            if (i3 == colNumberStart) {
                w = width - colWidth / 3;
            }
            g.setColor(lineColor);
            g.drawLine(0, 0, w, height);
            width -= colWidth;
            ++index;
        }
        byte[] imageBytes = null;
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream memoryImage = new MemoryCacheImageOutputStream(byteOutput);
        try {
            ImageIO.write((RenderedImage)image, "png", memoryImage);
            imageBytes = byteOutput.toByteArray();
            String base64Data = Base64Util.encodeToString((byte[])imageBytes);
            content.setBase64Data(base64Data);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
        finally {
            try {
                if (memoryImage != null) {
                    memoryImage.close();
                }
                if (byteOutput != null) {
                    byteOutput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        g.dispose();
        String imageByteKey = SlashBuilder.buildKey(report.getReportFullName(), cell.getName());
        ResourceCache.putObject((String)imageByteKey, (Object)imageBytes);
    }

    private Slash getSlash(SlashValue content, int index) {
        List slashes = content.getSlashes();
        if (index < slashes.size()) {
            return (Slash)slashes.get(index);
        }
        return null;
    }

    private Color getColor(String text) {
        if (text == null) {
            return null;
        }
        String[] str = text.split(",");
        return new Color(Integer.valueOf(str[0]), Integer.valueOf(str[1]), Integer.valueOf(str[2]));
    }

    public static String buildKey(String reportFullName, String cellName) {
        return "slash-" + reportFullName + "-" + cellName;
    }
}

