/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.cache;

import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.console.RequestHolder;
import com.bstek.ureport.console.cache.ObjectMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HttpSessionReportCache
implements ReportCache {
    private Map<String, ObjectMap> sessionReportMap = new HashMap<String, ObjectMap>();
    private boolean disabled;

    public Object getObject(String file) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return null;
        }
        ObjectMap objMap = this.getObjectMap(req);
        return objMap.get(file);
    }

    public void storeObject(String file, Object object) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return;
        }
        ObjectMap map = this.getObjectMap(req);
        map.put(file, object);
    }

    public boolean disabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    private ObjectMap getObjectMap(HttpServletRequest req) {
        ArrayList<String> expiredList = new ArrayList<String>();
        for (String key : this.sessionReportMap.keySet()) {
            ObjectMap reportObj = this.sessionReportMap.get(key);
            if (!reportObj.isExpired()) continue;
            expiredList.add(key);
        }
        for (String key : expiredList) {
            this.sessionReportMap.remove(key);
        }
        String sessionId = req.getSession().getId();
        ObjectMap obj = this.sessionReportMap.get(sessionId);
        if (obj != null) {
            return obj;
        }
        ObjectMap objMap = new ObjectMap();
        this.sessionReportMap.put(sessionId, objMap);
        return objMap;
    }
}

