/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console;

import com.bstek.ureport.console.RequestHolder;
import com.bstek.ureport.console.ServletAction;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 533049461276487971L;
    public static final String URL = "/ureport";
    private Map<String, ServletAction> actionMap = new HashMap<String, ServletAction>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext applicationContext = this.getWebApplicationContext(config);
        Collection handlers = applicationContext.getBeansOfType(ServletAction.class).values();
        for (ServletAction handler : handlers) {
            String url = handler.url();
            if (this.actionMap.containsKey(url)) {
                throw new RuntimeException("Handler [" + url + "] already exist.");
            }
            this.actionMap.put(url, handler);
        }
    }

    protected WebApplicationContext getWebApplicationContext(ServletConfig config) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletAction targetHandler;
        String path = req.getContextPath() + URL;
        String uri = req.getRequestURI();
        String targetUrl = uri.substring(path.length());
        if (targetUrl.length() < 1) {
            this.outContent(resp, "Welcome to use ureport,please specify target url.");
            return;
        }
        int slashPos = targetUrl.indexOf("/", 1);
        if (slashPos > -1) {
            targetUrl = targetUrl.substring(0, slashPos);
        }
        if ((targetHandler = this.actionMap.get(targetUrl)) == null) {
            this.outContent(resp, "Handler [" + targetUrl + "] not exist.");
            return;
        }
        RequestHolder.setRequest(req);
        try {
            targetHandler.execute(req, resp);
        }
        catch (Exception ex) {
            resp.setCharacterEncoding("UTF-8");
            PrintWriter pw = resp.getWriter();
            Throwable e = this.buildRootException(ex);
            resp.setStatus(500);
            String errorMsg = e.getMessage();
            if (StringUtils.isBlank((String)errorMsg)) {
                errorMsg = e.getClass().getName();
            }
            pw.write(errorMsg);
            pw.close();
            throw new ServletException((Throwable)ex);
        }
        finally {
            RequestHolder.clean();
        }
    }

    private Throwable buildRootException(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable;
        }
        return this.buildRootException(throwable.getCause());
    }

    private void outContent(HttpServletResponse resp, String msg) throws IOException {
        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        pw.write("<html>");
        pw.write("<header><title>UReport Console</title></header>");
        pw.write("<body>");
        pw.write(msg);
        pw.write("</body>");
        pw.write("</html>");
        pw.flush();
        pw.close();
    }
}

