/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.redis.serializer;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import org.springblade.core.redis.serializer.BytesWrapper;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class ProtoStuffSerializer
implements RedisSerializer<Object> {
    private final Schema<BytesWrapper> schema = RuntimeSchema.getSchema(BytesWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return null;
        }
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] byArray = ProtobufIOUtil.toByteArray(new BytesWrapper<Object>(object), this.schema, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (ObjectUtil.isEmpty((Object)bytes)) {
            return null;
        }
        BytesWrapper wrapper = new BytesWrapper();
        ProtobufIOUtil.mergeFrom((byte[])bytes, wrapper, this.schema);
        return wrapper.getValue();
    }
}

