/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.redis.config;

import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.redis.serializer.ProtoStuffSerializer;
import org.springblade.core.redis.serializer.RedisKeySerializer;
import org.springblade.core.tool.config.RedisConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;

@EnableCaching
@AutoConfiguration(before={RedisConfiguration.class, RedisAutoConfiguration.class})
public class RedisTemplateConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer() {
        return new ProtoStuffSerializer();
    }

    @Bean(name={"redisTemplate"})
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        RedisKeySerializer keySerializer = new RedisKeySerializer();
        redisTemplate.setKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)keySerializer);
        redisTemplate.setValueSerializer(redisSerializer);
        redisTemplate.setHashValueSerializer(redisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={ValueOperations.class})
    public ValueOperations valueOperations(RedisTemplate redisTemplate) {
        return redisTemplate.opsForValue();
    }

    @Bean
    public BladeRedis bladeRedis(RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate) {
        return new BladeRedis(redisTemplate, stringRedisTemplate);
    }
}

