/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springblade.core.oss.QiniuTemplate;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OssConfiguration.class})
@ConditionalOnClass(value={Auth.class, UploadManager.class, BucketManager.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="qiniu")
public class QiniuConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Configuration.class})
    public Configuration qnConfiguration() {
        return new Configuration(Region.autoRegion());
    }

    @Bean
    @ConditionalOnMissingBean(value={Auth.class})
    public Auth auth(OssProperties ossProperties) {
        return Auth.create((String)ossProperties.getAccessKey(), (String)ossProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public UploadManager uploadManager(Configuration cfg) {
        return new UploadManager(cfg);
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public BucketManager bucketManager(OssProperties ossProperties, Configuration cfg) {
        return new BucketManager(Auth.create((String)ossProperties.getAccessKey(), (String)ossProperties.getSecretKey()), cfg);
    }

    @Bean
    @ConditionalOnBean(value={Auth.class, UploadManager.class, BucketManager.class})
    @ConditionalOnMissingBean(value={QiniuTemplate.class})
    public QiniuTemplate qiniuTemplate(OssRule ossRule, OssProperties ossProperties, Auth auth, UploadManager uploadManager, BucketManager bucketManager) {
        return new QiniuTemplate(auth, uploadManager, bucketManager, ossProperties, ossRule);
    }
}

