/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import io.minio.MinioClient;
import org.springblade.core.oss.MinioTemplate;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OssConfiguration.class})
@ConditionalOnClass(value={MinioClient.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="minio")
public class MinioConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MinioClient.class})
    public MinioClient minioClient(OssProperties ossProperties) {
        return MinioClient.builder().endpoint(ossProperties.getEndpoint()).credentials(ossProperties.getAccessKey(), ossProperties.getSecretKey()).build();
    }

    @Bean
    @ConditionalOnBean(value={MinioClient.class})
    @ConditionalOnMissingBean(value={MinioTemplate.class})
    public MinioTemplate minioTemplate(OssRule ossRule, OssProperties ossProperties, MinioClient minioClient) {
        return new MinioTemplate(minioClient, ossRule, ossProperties);
    }
}

