/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class TencentCosTemplate
implements OssTemplate {
    private final COSClient cosClient;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.cosClient.createBucket(this.getBucketName(bucketName));
            this.cosClient.setBucketAcl(this.getBucketName(bucketName), CannedAccessControlList.PublicRead);
        }
    }

    @Override
    public void removeBucket(String bucketName) {
        this.cosClient.deleteBucket(this.getBucketName(bucketName));
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.cosClient.doesBucketExist(this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.cosClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.cosClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.cosClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMD5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    @Override
    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    @Override
    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (cover) {
            this.cosClient.putObject(this.getBucketName(bucketName), key, stream, objectMetadata);
        } else {
            PutObjectResult response = this.cosClient.putObject(this.getBucketName(bucketName), key, stream, objectMetadata);
            int retry = 0;
            int retryCount = 5;
            while (!StringUtils.hasText((String)response.getETag()) && retry < retryCount) {
                response = this.cosClient.putObject(this.getBucketName(bucketName), key, stream, objectMetadata);
                ++retry;
            }
        }
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.cosClient.deleteObject(this.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.cosClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName).concat("-").concat(this.ossProperties.getAppId());
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.cosClient.getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(this.getBucketName(bucketName));
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public String getEndpoint() {
        if (StringUtil.isBlank((CharSequence)this.ossProperties.getTransformEndpoint())) {
            return this.ossProperties.getEndpoint();
        }
        return StringUtil.removeSuffix((CharSequence)this.ossProperties.getTransformEndpoint(), (CharSequence)"/");
    }

    @Generated
    public TencentCosTemplate(COSClient cosClient, OssProperties ossProperties, OssRule ossRule) {
        this.cosClient = cosClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

