/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss;

import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteObject;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.enums.PolicyType;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.web.multipart.MultipartFile;

public class MinioTemplate
implements OssTemplate {
    private final MinioClient client;
    private final OssRule ossRule;
    private final OssProperties ossProperties;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.getBucketName(bucketName))).build())) {
            this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.getBucketName(bucketName))).build());
            this.client.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(this.getBucketName(bucketName))).config(MinioTemplate.getPolicyType(this.getBucketName(bucketName), PolicyType.READ)).build());
        }
    }

    public Bucket getBucket() {
        return this.getBucket(this.getBucketName());
    }

    public Bucket getBucket(String bucketName) {
        Optional<Bucket> bucketOptional = this.client.listBuckets().stream().filter(bucket -> bucket.name().equals(this.getBucketName(bucketName))).findFirst();
        return bucketOptional.orElse(null);
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    @Override
    public void removeBucket(String bucketName) {
        this.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(this.getBucketName(bucketName))).build());
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.getBucketName(bucketName))).build());
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.copyFile(bucketName, fileName, destBucketName, fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build()).bucket(this.getBucketName(destBucketName))).object(destFileName)).build());
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        StatObjectResponse stat = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.object()) ? fileName : stat.object());
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(String.valueOf(stat.hashCode()));
        ossFile.setLength(stat.size());
        ossFile.setPutTime(DateUtil.toDate((LocalDateTime)stat.lastModified().toLocalDateTime()));
        ossFile.setContentType(stat.contentType());
        return ossFile;
    }

    @Override
    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.getEndpoint().concat("/").concat(this.getBucketName()).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.getEndpoint().concat("/").concat(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, file.getOriginalFilename(), file.getInputStream());
    }

    @Override
    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.putFile(bucketName, fileName, stream, "application/octet-stream");
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream, String contentType) {
        this.makeBucket(bucketName);
        String originalName = fileName;
        fileName = this.getFileName(fileName);
        this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).stream(stream, (long)stream.available(), -1L).contentType(contentType).build());
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.removeFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.getBucketName(bucketName))).object(fileName)).build());
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        this.removeFiles(this.ossProperties.getBucketName(), fileNames);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        Stream<DeleteObject> stream = fileNames.stream().map(DeleteObject::new);
        this.client.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(this.getBucketName(bucketName))).objects(stream::iterator).build());
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getPresignedObjectUrl(String bucketName, String fileName, Integer expires) {
        return this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.getBucketName(bucketName))).object(fileName)).expiry(expires.intValue()).build());
    }

    public String getPolicyType(PolicyType policyType) {
        return MinioTemplate.getPolicyType(this.getBucketName(), policyType);
    }

    public static String getPolicyType(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("    \"Statement\": [\n");
        builder.append("        {\n");
        builder.append("            \"Action\": [\n");
        switch (policyType) {
            case WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            case READ_WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucket\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            default: {
                builder.append("                \"s3:GetBucketLocation\"\n");
            }
        }
        builder.append("            ],\n");
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n");
        builder.append("        },\n");
        if (PolicyType.READ.equals((Object)policyType)) {
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:ListBucket\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Deny\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n");
            builder.append("        },\n");
        }
        builder.append("        {\n");
        builder.append("            \"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:GetObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n");
        builder.append("        }\n");
        builder.append("    ],\n");
        builder.append("    \"Version\": \"2012-10-17\"\n");
        builder.append("}\n");
        return builder.toString();
    }

    public String getOssHost(String bucketName) {
        return this.getEndpoint() + "/" + this.getBucketName(bucketName);
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public String getEndpoint() {
        if (StringUtil.isBlank((CharSequence)this.ossProperties.getTransformEndpoint())) {
            return this.ossProperties.getEndpoint();
        }
        return this.ossProperties.getTransformEndpoint();
    }

    @Generated
    public MinioTemplate(MinioClient client, OssRule ossRule, OssProperties ossProperties) {
        this.client = client;
        this.ossRule = ossRule;
        this.ossProperties = ossProperties;
    }
}

