/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;

public class NumberUtil
extends NumberUtils {
    protected static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public static int toInt(String str) {
        return NumberUtil.toInt(str, -1);
    }

    public static int toInt(@Nullable String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtil.toLong(str, 0L);
    }

    public static long toLong(@Nullable String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Double toDouble(String value) {
        return NumberUtil.toDouble(value, null);
    }

    public static Double toDouble(@Nullable String value, Double defaultValue) {
        if (value != null) {
            return Double.valueOf(value.trim());
        }
        return defaultValue;
    }

    public static Float toFloat(String value) {
        return NumberUtil.toFloat(value, null);
    }

    public static Float toFloat(@Nullable String value, Float defaultValue) {
        if (value != null) {
            return Float.valueOf(value.trim());
        }
        return defaultValue;
    }

    public static String to62String(long i) {
        int radix = DIGITS.length;
        byte[] buf = new byte[65];
        int charPos = 64;
        for (i = -i; i <= (long)(-radix); i /= (long)radix) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
        }
        buf[charPos] = DIGITS[(int)(-i)];
        return new String(buf, charPos, 65 - charPos);
    }

    public static long form62String(String s) {
        char[] chars = s.toCharArray();
        long res = 0L;
        int len = chars.length;
        int lenIdx = len - 1;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            int idx = c >= 'A' && c <= 'Z' ? c - 29 : (c >= 'a' && c <= 'z' ? c - 87 : c - 48);
            res += (long)((double)idx * StrictMath.pow(62.0, lenIdx - i));
        }
        return res;
    }
}

