/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.redis;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public class RedisKeySerializer
implements RedisSerializer<Object> {
    private final Charset charset;
    private final ConversionService converter;

    public RedisKeySerializer() {
        this(StandardCharsets.UTF_8);
    }

    public RedisKeySerializer(Charset charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        this.charset = charset;
        this.converter = DefaultConversionService.getSharedInstance();
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, this.charset);
    }

    @Nullable
    public byte[] serialize(Object object) {
        Objects.requireNonNull(object, "redis key is null");
        String key = object instanceof SimpleKey ? "" : (object instanceof String ? (String)object : (String)this.converter.convert(object, String.class));
        return key.getBytes(this.charset);
    }
}

