/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.props;

import io.jsonwebtoken.JwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="blade.token")
public class BladeTokenProperties {
    private static final Logger log = LoggerFactory.getLogger(BladeTokenProperties.class);
    private String signKey = "";
    private String aesKey = "";

    public String getSignKey() {
        if (this.signKey.length() < 32) {
            throw new JwtException("\u8bf7\u914d\u7f6e blade.token.sign-key \u7684\u503c, \u957f\u5ea632\u4f4d\u4ee5\u4e0a");
        }
        return this.signKey;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BladeTokenProperties)) {
            return false;
        }
        BladeTokenProperties other = (BladeTokenProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signKey = this.getSignKey();
        String other$signKey = other.getSignKey();
        if (this$signKey == null ? other$signKey != null : !this$signKey.equals(other$signKey)) {
            return false;
        }
        String this$aesKey = this.getAesKey();
        String other$aesKey = other.getAesKey();
        return !(this$aesKey == null ? other$aesKey != null : !this$aesKey.equals(other$aesKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BladeTokenProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signKey = this.getSignKey();
        result = result * 59 + ($signKey == null ? 43 : $signKey.hashCode());
        String $aesKey = this.getAesKey();
        result = result * 59 + ($aesKey == null ? 43 : $aesKey.hashCode());
        return result;
    }

    public String toString() {
        return "BladeTokenProperties(signKey=" + this.getSignKey() + ", aesKey=" + this.getAesKey() + ")";
    }
}

