/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.publisher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import org.springblade.core.log.event.ErrorLogEvent;
import org.springblade.core.log.model.LogError;
import org.springblade.core.log.utils.LogAbstractUtil;
import org.springblade.core.tool.utils.Exceptions;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.context.ApplicationEvent;

public class ErrorLogPublisher {
    public static void publishEvent(Throwable error, String requestUri) {
        HttpServletRequest request = WebUtil.getRequest();
        LogError logError = new LogError();
        logError.setRequestUri(requestUri);
        if (Func.isNotEmpty((Object)error)) {
            logError.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
            logError.setExceptionName(error.getClass().getName());
            logError.setMessage(error.getMessage());
            Object[] elements = error.getStackTrace();
            if (Func.isNotEmpty((Object[])elements)) {
                Object element = elements[0];
                logError.setMethodName(((StackTraceElement)element).getMethodName());
                logError.setMethodClass(((StackTraceElement)element).getClassName());
                logError.setFileName(((StackTraceElement)element).getFileName());
                logError.setLineNumber(((StackTraceElement)element).getLineNumber());
            }
        }
        LogAbstractUtil.addRequestInfoToLog(request, logError);
        HashMap<String, Object> event = new HashMap<String, Object>(16);
        event.put("log", logError);
        event.put("request", request);
        SpringUtil.publishEvent((ApplicationEvent)new ErrorLogEvent(event));
    }
}

