/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.config;

import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.aspect.ApiLogAspect;
import org.springblade.core.log.event.ApiLogListener;
import org.springblade.core.log.event.ErrorLogListener;
import org.springblade.core.log.event.UsualLogListener;
import org.springblade.core.log.feign.ILogClient;
import org.springblade.core.log.logger.BladeLogger;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication
public class BladeLogToolAutoConfiguration {
    private final ILogClient logService;
    private final ServerInfo serverInfo;
    private final BladeProperties bladeProperties;

    @Bean
    @ConditionalOnProperty(value={"blade.logapi.enabled"}, havingValue="true", matchIfMissing=true)
    public ApiLogAspect apiLogAspect() {
        return new ApiLogAspect();
    }

    @Bean
    @ConditionalOnProperty(value={"blade.logapi.enabled"}, havingValue="true", matchIfMissing=true)
    public ApiLogListener apiLogListener() {
        return new ApiLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"blade.logerror.enabled"}, havingValue="true", matchIfMissing=true)
    public ErrorLogListener errorEventListener() {
        return new ErrorLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"blade.logusual.enabled"}, havingValue="true", matchIfMissing=true)
    public UsualLogListener bladeEventListener() {
        return new UsualLogListener(this.logService, this.serverInfo, this.bladeProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"blade.logusual.enabled"}, havingValue="true", matchIfMissing=true)
    public BladeLogger bladeLogger() {
        return new BladeLogger();
    }

    public BladeLogToolAutoConfiguration(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        this.logService = logService;
        this.serverInfo = serverInfo;
        this.bladeProperties = bladeProperties;
    }
}

