/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.loadbalancer.rule;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class GrayscaleEnvPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String GREYSCALE_KEY = "blade.loadbalancer.version";
    private static final String METADATA_KEY = "spring.cloud.nacos.discovery.metadata.version";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String version = environment.getProperty(GREYSCALE_KEY);
        if (StringUtils.hasText((String)version)) {
            environment.getSystemProperties().put(METADATA_KEY, version);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

