/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.datascope.config;

import org.springblade.core.datascope.handler.BladeDataScopeHandler;
import org.springblade.core.datascope.handler.BladeScopeModelHandler;
import org.springblade.core.datascope.handler.DataScopeHandler;
import org.springblade.core.datascope.handler.ScopeModelHandler;
import org.springblade.core.datascope.interceptor.DataScopeInterceptor;
import org.springblade.core.datascope.props.DataScopeProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={DataScopeProperties.class})
public class DataScopeConfiguration {
    private final JdbcTemplate jdbcTemplate;

    @Bean
    @ConditionalOnMissingBean(value={ScopeModelHandler.class})
    public ScopeModelHandler scopeModelHandler() {
        return new BladeScopeModelHandler(this.jdbcTemplate);
    }

    @Bean
    @ConditionalOnBean(value={ScopeModelHandler.class})
    @ConditionalOnMissingBean(value={DataScopeHandler.class})
    public DataScopeHandler dataScopeHandler(ScopeModelHandler scopeModelHandler) {
        return new BladeDataScopeHandler(scopeModelHandler);
    }

    @Bean
    @ConditionalOnBean(value={DataScopeHandler.class})
    @ConditionalOnMissingBean(value={DataScopeInterceptor.class})
    public DataScopeInterceptor interceptor(DataScopeHandler dataScopeHandler, DataScopeProperties dataScopeProperties) {
        return new DataScopeInterceptor(dataScopeHandler, dataScopeProperties);
    }

    public DataScopeConfiguration(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

