/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.cloud.header.BladeFeignAccountGetter;
import org.springblade.core.cloud.http.BladeHttpProperties;
import org.springblade.core.cloud.http.HttpLoggingInterceptor;
import org.springblade.core.cloud.http.LbRestTemplate;
import org.springblade.core.cloud.http.OkHttpSlf4jLogger;
import org.springblade.core.cloud.http.RestTemplateHeaderInterceptor;
import org.springblade.core.cloud.http.client.OkHttp3ClientHttpRequestFactory;
import org.springblade.core.cloud.props.BladeFeignHeadersProperties;
import org.springblade.core.tool.ssl.DisableValidationTrustManager;
import org.springblade.core.tool.ssl.TrustAllHostNames;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.Holder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalOnProperty(value={"blade.http.enabled"}, matchIfMissing=true)
public class RestTemplateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfiguration.class);
    private final BladeHttpProperties properties;

    @Bean
    public HttpLoggingInterceptor loggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new OkHttpSlf4jLogger());
        interceptor.setLevel(this.properties.getLevel());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionPool httpClientConnectionPool() {
        int maxTotalConnections = this.properties.getMaxConnections();
        long timeToLive = this.properties.getTimeToLive();
        TimeUnit ttlUnit = this.properties.getTimeUnit();
        return new ConnectionPool(maxTotalConnections, timeToLive, ttlUnit);
    }

    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient okHttpClient(ConnectionPool connectionPool, HttpLoggingInterceptor interceptor) {
        boolean followRedirects = this.properties.isFollowRedirects();
        int connectTimeout = this.properties.getConnectionTimeout();
        return this.createBuilder(this.properties.isDisableSslValidation()).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(followRedirects).connectionPool(connectionPool).addInterceptor((Interceptor)interceptor).build();
    }

    private OkHttpClient.Builder createBuilder(boolean disableSslValidation) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (disableSslValidation) {
            try {
                X509TrustManager disabledTrustManager = DisableValidationTrustManager.INSTANCE;
                TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, Holder.SECURE_RANDOM);
                SSLSocketFactory disabledSslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(disabledSslSocketFactory, disabledTrustManager);
                builder.hostnameVerifier((HostnameVerifier)TrustAllHostNames.INSTANCE);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", (Throwable)e);
            }
        }
        return builder;
    }

    @Bean
    public RestTemplateHeaderInterceptor requestHeaderInterceptor(@Autowired(required=false) @Nullable BladeFeignAccountGetter accountGetter, BladeFeignHeadersProperties properties) {
        return new RestTemplateHeaderInterceptor(accountGetter, properties);
    }

    private static void configMessageConverters(ApplicationContext context, List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof MappingJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(Charsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter((ObjectMapper)context.getBean(ObjectMapper.class)));
    }

    public RestTemplateConfiguration(BladeHttpProperties properties) {
        this.properties = properties;
    }

    @AutoConfiguration
    @ConditionalOnClass(value={OkHttpClient.class})
    @ConditionalOnProperty(value={"blade.http.lb-rest-template.enable"})
    public static class LbRestTemplateAutoConfiguration {
        private final ApplicationContext context;

        @Bean
        @LoadBalanced
        @ConditionalOnMissingBean
        public LbRestTemplate lbRestTemplate(RestTemplateBuilder restTemplateBuilder, OkHttpClient okHttpClient) {
            restTemplateBuilder.requestFactory(() -> new OkHttp3ClientHttpRequestFactory(okHttpClient));
            LbRestTemplate restTemplate = (LbRestTemplate)restTemplateBuilder.build(LbRestTemplate.class);
            restTemplate.getInterceptors().add((ClientHttpRequestInterceptor)this.context.getBean(RestTemplateHeaderInterceptor.class));
            RestTemplateConfiguration.configMessageConverters(this.context, restTemplate.getMessageConverters());
            return restTemplate;
        }

        public LbRestTemplateAutoConfiguration(ApplicationContext context) {
            this.context = context;
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={OkHttpClient.class})
    @ConditionalOnProperty(value={"blade.http.rest-template.enable"})
    public static class RestTemplateAutoConfiguration {
        private final ApplicationContext context;

        @Bean
        @ConditionalOnMissingBean
        public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, OkHttpClient okHttpClient) {
            restTemplateBuilder.requestFactory(() -> new OkHttp3ClientHttpRequestFactory(okHttpClient));
            RestTemplate restTemplate = restTemplateBuilder.build();
            RestTemplateConfiguration.configMessageConverters(this.context, restTemplate.getMessageConverters());
            return restTemplate;
        }

        public RestTemplateAutoConfiguration(ApplicationContext context) {
            this.context = context;
        }
    }
}

