/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.tenant;

import java.util.function.Supplier;
import org.springblade.core.secure.utils.SecureUtil;
import org.springframework.util.Assert;

public final class TenantIdUtil {
    private static final ThreadLocal<String> tl = new ThreadLocal();

    public static String get() {
        String tenantId = tl.get();
        if (tenantId != null) {
            return tenantId;
        }
        return SecureUtil.getTenantId();
    }

    public static <R> R use(String tenantId, Supplier<R> supplier) {
        Assert.hasText((String)tenantId, (String)"\u53c2\u6570 tenantId \u4e3a\u7a7a");
        tl.set(tenantId);
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            tl.remove();
        }
    }

    public static void use(String tenantId, Runnable runnable) {
        Assert.hasText((String)tenantId, (String)"\u53c2\u6570 tenantId \u4e3a\u7a7a");
        tl.set(tenantId);
        try {
            runnable.run();
        }
        finally {
            tl.remove();
        }
    }

    private TenantIdUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

