/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws.internal;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.CharMatcher;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;

public abstract class ValidatingRequest
extends Request {
    private static final Splitter COMMA_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private WebService.Action action;
    private LocalConnector localConnector;

    public void setAction(WebService.Action action) {
        this.action = action;
    }

    public WebService.Action action() {
        return this.action;
    }

    @Override
    public LocalConnector localConnector() {
        Preconditions.checkNotNull(this.localConnector, "Local connector has not been set");
        return this.localConnector;
    }

    public void setLocalConnector(LocalConnector lc) {
        this.localConnector = lc;
    }

    @Override
    @CheckForNull
    public String param(String key) {
        return this.param(key, true);
    }

    @Override
    public List<String> multiParam(String key) {
        WebService.Param definition = this.action.param(key);
        List<String> values = this.readMultiParamOrDefaultValue(key, definition);
        return ValidatingRequest.validateValues(values, definition);
    }

    @Override
    @CheckForNull
    public InputStream paramAsInputStream(String key) {
        return this.readInputStreamParam(key);
    }

    @Override
    @CheckForNull
    public Request.Part paramAsPart(String key) {
        return this.readPart(key);
    }

    @CheckForNull
    private String param(String key, boolean validateValue) {
        String trimmedValue;
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        String string = trimmedValue = value == null ? null : CharMatcher.WHITESPACE.trimFrom(value);
        if (trimmedValue != null && validateValue) {
            ValidatingRequest.validateValue(trimmedValue, definition);
        }
        return trimmedValue;
    }

    @Override
    @CheckForNull
    public List<String> paramAsStrings(String key) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value == null) {
            return null;
        }
        List<String> values = COMMA_SPLITTER.splitToList(value);
        return ValidatingRequest.validateValues(values, definition);
    }

    @Override
    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        List<String> values = this.paramAsStrings(key);
        if (values == null) {
            return null;
        }
        return values.stream().map(value -> Enum.valueOf(enumClass, value)).collect(Collectors.toList());
    }

    @CheckForNull
    private String readParamOrDefaultValue(String key, @Nullable WebService.Param definition) {
        Preconditions.checkArgument(definition != null, "BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
        String deprecatedKey = definition.deprecatedKey();
        String value = deprecatedKey != null ? StringUtils.defaultString(this.readParam(deprecatedKey), this.readParam(key)) : this.readParam(key);
        return StringUtils.defaultString(value, definition.defaultValue());
    }

    private List<String> readMultiParamOrDefaultValue(String key, @Nullable WebService.Param definition) {
        List<String> deprecatedKeyValues;
        Preconditions.checkArgument(definition != null, "BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
        List<String> keyValues = this.readMultiParam(key);
        if (!keyValues.isEmpty()) {
            return keyValues;
        }
        String deprecatedKey = definition.deprecatedKey();
        List<String> list = deprecatedKeyValues = deprecatedKey == null ? Collections.emptyList() : this.readMultiParam(deprecatedKey);
        if (!deprecatedKeyValues.isEmpty()) {
            return deprecatedKeyValues;
        }
        String defaultValue = definition.defaultValue();
        return defaultValue == null ? Collections.emptyList() : Collections.singletonList(defaultValue);
    }

    @CheckForNull
    protected abstract String readParam(String var1);

    protected abstract List<String> readMultiParam(String var1);

    @CheckForNull
    protected abstract InputStream readInputStreamParam(String var1);

    @CheckForNull
    protected abstract Request.Part readPart(String var1);

    private static List<String> validateValues(List<String> values, WebService.Param definition) {
        Integer maximumValues = definition.maxValuesAllowed();
        Preconditions.checkArgument(maximumValues == null || values.size() <= maximumValues, "'%s' can contains only %s values, got %s", definition.key(), maximumValues, values.size());
        values.forEach(value -> ValidatingRequest.validateValue(value, definition));
        return values;
    }

    private static void validateValue(String value, WebService.Param definition) {
        Set<String> possibleValues = definition.possibleValues();
        Preconditions.checkArgument(possibleValues == null || possibleValues.contains(value), "Value of parameter '%s' (%s) must be one of: %s", definition.key(), value, possibleValues);
    }
}

