/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.coverage.internal;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultCoverage
extends DefaultStorable
implements NewCoverage {
    private InputFile inputFile;
    private CoverageType type;
    private int totalCoveredLines = 0;
    private int totalConditions = 0;
    private int totalCoveredConditions = 0;
    private SortedMap<Integer, Integer> hitsByLine = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> conditionsByLine = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> coveredConditionsByLine = new TreeMap<Integer, Integer>();

    public DefaultCoverage() {
    }

    public DefaultCoverage(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultCoverage onFile(InputFile inputFile) {
        this.inputFile = inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public NewCoverage ofType(CoverageType type) {
        this.type = Objects.requireNonNull(type, "type can't be null");
        return this;
    }

    public CoverageType type() {
        return this.type;
    }

    @Override
    public NewCoverage lineHits(int line, int hits) {
        this.validateFile();
        this.validateLine(line);
        if (!this.hitsByLine.containsKey(line)) {
            this.hitsByLine.put(line, hits);
            if (hits > 0) {
                ++this.totalCoveredLines;
            }
        }
        return this;
    }

    private void validateLine(int line) {
        Preconditions.checkState(line <= this.inputFile.lines(), "Line %s is out of range in the file %s (lines: %s)", line, this.inputFile.relativePath(), this.inputFile.lines());
        Preconditions.checkState(line > 0, "Line number must be strictly positive: %s", line);
    }

    private void validateFile() {
        Objects.requireNonNull(this.inputFile, "Call onFile() first");
    }

    @Override
    public NewCoverage conditions(int line, int conditions, int coveredConditions) {
        this.validateFile();
        this.validateLine(line);
        if (conditions > 0 && !this.conditionsByLine.containsKey(line)) {
            this.totalConditions += conditions;
            this.totalCoveredConditions += coveredConditions;
            this.conditionsByLine.put(line, conditions);
            this.coveredConditionsByLine.put(line, coveredConditions);
        }
        return this;
    }

    public int coveredLines() {
        return this.totalCoveredLines;
    }

    public int linesToCover() {
        return this.hitsByLine.size();
    }

    public int conditions() {
        return this.totalConditions;
    }

    public int coveredConditions() {
        return this.totalCoveredConditions;
    }

    public SortedMap<Integer, Integer> hitsByLine() {
        return Collections.unmodifiableSortedMap(this.hitsByLine);
    }

    public SortedMap<Integer, Integer> conditionsByLine() {
        return Collections.unmodifiableSortedMap(this.conditionsByLine);
    }

    public SortedMap<Integer, Integer> coveredConditionsByLine() {
        return Collections.unmodifiableSortedMap(this.coveredConditionsByLine);
    }

    @Override
    public void doSave() {
        this.validateFile();
        this.storage.store(this);
    }
}

