/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.enhance;

import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class FutureCompletionHandler<V, A>
implements CompletionHandler<V, A>,
Future<V>,
Runnable {
    private CompletionHandler<V, A> completionHandler;
    private A attach;
    private V result;
    private boolean done = false;
    private boolean cancel = false;
    private Throwable exception;

    public FutureCompletionHandler(CompletionHandler<V, A> completionHandler, A attach) {
        this.completionHandler = completionHandler;
        this.attach = attach;
    }

    public FutureCompletionHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(V result, A selectionKey) {
        this.result = result;
        this.done = true;
        FutureCompletionHandler futureCompletionHandler = this;
        synchronized (futureCompletionHandler) {
            this.notify();
        }
        if (this.completionHandler != null) {
            this.completionHandler.completed(result, this.attach);
        }
    }

    @Override
    public void failed(Throwable exc, A attachment) {
        this.exception = exc;
        this.done = true;
        if (this.completionHandler != null) {
            this.completionHandler.failed(exc, attachment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done || this.cancel) {
            return false;
        }
        this.cancel = true;
        this.done = true;
        FutureCompletionHandler futureCompletionHandler = this;
        synchronized (futureCompletionHandler) {
            this.notify();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        if (this.done) {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }
        this.wait();
        return this.get();
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.done) {
            return this.get();
        }
        this.wait(unit.toMillis(timeout));
        if (this.done) {
            return this.get();
        }
        throw new TimeoutException();
    }

    @Override
    public synchronized void run() {
        if (!this.done) {
            this.cancel(true);
            this.completionHandler.failed(new TimeoutException(), this.attach);
        }
    }
}

