/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.enhance;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritePendingException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.enhance.ByteBufferArray;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelGroup;
import org.smartboot.socket.enhance.FutureCompletionHandler;

final class EnhanceAsynchronousSocketChannel
extends AsynchronousSocketChannel {
    private final SocketChannel channel;
    private final EnhanceAsynchronousChannelGroup group;
    private final EnhanceAsynchronousChannelGroup.Worker readWorker;
    private final EnhanceAsynchronousChannelGroup.Worker writeWorker;
    private final EnhanceAsynchronousChannelGroup.Worker connectWorker;
    private ByteBuffer readBuffer;
    private ByteBufferArray scatteringReadBuffer;
    private ByteBuffer writeBuffer;
    private ByteBufferArray gatheringWriteBuffer;
    private CompletionHandler<Number, Object> readCompletionHandler;
    private CompletionHandler<Number, Object> writeCompletionHandler;
    private CompletionHandler<Void, Object> connectCompletionHandler;
    private FutureCompletionHandler<Void, Void> connectFuture;
    private FutureCompletionHandler<? extends Number, Object> readFuture;
    private FutureCompletionHandler<? extends Number, Object> writeFuture;
    private Object readAttachment;
    private Object writeAttachment;
    private Object connectAttachment;
    private SelectionKey readSelectionKey;
    private SelectionKey readFutureSelectionKey;
    private SelectionKey writeSelectionKey;
    private SelectionKey writeFutureSelectionKey;
    private SelectionKey connectSelectionKey;
    private boolean writePending;
    private boolean readPending;
    private boolean connectionPending;
    private SocketAddress remote;
    private int writeInvoker;

    public EnhanceAsynchronousSocketChannel(EnhanceAsynchronousChannelGroup group, SocketChannel channel) throws IOException {
        super(group.provider());
        this.group = group;
        this.channel = channel;
        this.readWorker = group.getReadWorker();
        this.writeWorker = group.getWriteWorker();
        this.connectWorker = group.getConnectWorker();
        channel.configureBlocking(false);
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            exception = e;
        }
        if (this.readSelectionKey != null) {
            this.readSelectionKey.cancel();
            this.readSelectionKey = null;
        }
        if (this.readFutureSelectionKey != null) {
            this.readFutureSelectionKey.cancel();
            this.readFutureSelectionKey = null;
        }
        if (this.writeSelectionKey != null) {
            this.writeSelectionKey.cancel();
            this.writeSelectionKey = null;
        }
        if (this.writeFutureSelectionKey != null) {
            this.writeFutureSelectionKey.cancel();
            this.writeFutureSelectionKey = null;
        }
        if (this.connectSelectionKey != null) {
            this.connectSelectionKey.cancel();
            this.connectSelectionKey = null;
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        this.channel.bind(local);
        return this;
    }

    @Override
    public <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.channel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.channel.supportedOptions();
    }

    @Override
    public AsynchronousSocketChannel shutdownInput() throws IOException {
        this.channel.shutdownInput();
        return this;
    }

    @Override
    public AsynchronousSocketChannel shutdownOutput() throws IOException {
        this.channel.shutdownOutput();
        return this;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        if (this.group.isTerminated()) {
            throw new ShutdownChannelGroupException();
        }
        if (this.channel.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.connectionPending) {
            throw new ConnectionPendingException();
        }
        this.connectionPending = true;
        this.connectAttachment = attachment;
        this.connectCompletionHandler = handler;
        this.remote = remote;
        this.doConnect();
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        FutureCompletionHandler connectFuture = new FutureCompletionHandler();
        this.connect(remote, null, connectFuture);
        this.connectFuture = connectFuture;
        return connectFuture;
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read0(dst, null, timeout, unit, attachment, handler);
    }

    private <V extends Number, A> void read0(ByteBuffer readBuffer, ByteBufferArray scattering, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        if (this.readPending) {
            throw new ReadPendingException();
        }
        this.readPending = true;
        this.readBuffer = readBuffer;
        this.scatteringReadBuffer = scattering;
        this.readAttachment = attachment;
        if (timeout > 0L) {
            this.readFuture = new FutureCompletionHandler<V, Object>(handler, this.readAttachment);
            this.readCompletionHandler = this.readFuture;
            this.group.getScheduledExecutor().schedule(this.readFuture, timeout, unit);
        } else {
            this.readCompletionHandler = handler;
        }
        this.doRead(this.readFuture != null);
    }

    @Override
    public Future<Integer> read(ByteBuffer readBuffer) {
        FutureCompletionHandler readFuture = new FutureCompletionHandler();
        this.readFuture = readFuture;
        this.read(readBuffer, 0L, TimeUnit.MILLISECONDS, null, readFuture);
        return readFuture;
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.read0(null, new ByteBufferArray(dsts, offset, length), timeout, unit, attachment, handler);
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write0(src, null, timeout, unit, attachment, handler);
    }

    private <V extends Number, A> void write0(ByteBuffer writeBuffer, ByteBufferArray gathering, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        this.writeBuffer = writeBuffer;
        this.gatheringWriteBuffer = gathering;
        this.writeAttachment = attachment;
        if (timeout > 0L) {
            this.writeFuture = new FutureCompletionHandler<V, Object>(handler, this.writeAttachment);
            this.writeCompletionHandler = this.writeFuture;
            this.group.getScheduledExecutor().schedule(this.writeFuture, timeout, unit);
        } else {
            this.writeCompletionHandler = handler;
        }
        this.doWrite();
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        FutureCompletionHandler writeFuture = new FutureCompletionHandler();
        this.writeFuture = writeFuture;
        this.write0(src, null, 0L, TimeUnit.MILLISECONDS, null, writeFuture);
        return writeFuture;
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.write0(null, new ByteBufferArray(srcs, offset, length), timeout, unit, attachment, handler);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public void doConnect() {
        block6: {
            try {
                if (this.connectFuture != null && this.connectFuture.isDone()) {
                    this.resetConnect();
                    return;
                }
                boolean connected = this.channel.isConnectionPending();
                if (connected || this.channel.connect(this.remote)) {
                    connected = this.channel.finishConnect();
                }
                if (connected) {
                    CompletionHandler<Void, Object> completionHandler = this.connectCompletionHandler;
                    Object attach = this.connectAttachment;
                    this.resetConnect();
                    completionHandler.completed(null, attach);
                    break block6;
                }
                if (this.connectSelectionKey == null) {
                    this.connectWorker.addRegister(selector -> {
                        try {
                            this.connectSelectionKey = this.channel.register((Selector)selector, 8, this);
                        }
                        catch (ClosedChannelException e) {
                            this.connectCompletionHandler.failed(e, this.connectAttachment);
                        }
                    });
                    break block6;
                }
                throw new IOException("unKnow exception");
            }
            catch (IOException e) {
                this.connectCompletionHandler.failed(e, this.connectAttachment);
            }
        }
    }

    private void resetConnect() {
        this.connectionPending = false;
        this.connectFuture = null;
        this.connectAttachment = null;
        this.connectCompletionHandler = null;
    }

    public void doRead(boolean direct) {
        try {
            if (this.readFuture != null && this.readFuture.isDone()) {
                this.group.removeOps(this.readSelectionKey, 1);
                this.resetRead();
                return;
            }
            boolean directRead = direct || Thread.currentThread() == this.readWorker.getWorkerThread() && this.readWorker.invoker++ < 8;
            long readSize = 0L;
            boolean hasRemain = true;
            if (directRead) {
                if (this.scatteringReadBuffer != null) {
                    readSize = this.channel.read(this.scatteringReadBuffer.getBuffers(), this.scatteringReadBuffer.getOffset(), this.scatteringReadBuffer.getLength());
                    hasRemain = this.hasRemaining(this.scatteringReadBuffer);
                } else {
                    readSize = this.channel.read(this.readBuffer);
                    hasRemain = this.readBuffer.hasRemaining();
                }
            }
            if (this.readFuture != null && readSize == 0L) {
                this.group.removeOps(this.readSelectionKey, 1);
                this.group.registerFuture(selector -> {
                    try {
                        this.readFutureSelectionKey = this.channel.register((Selector)selector, 1, this);
                    }
                    catch (ClosedChannelException e) {
                        e.printStackTrace();
                        this.doRead(true);
                    }
                }, 1);
                return;
            }
            if (readSize != 0L || !hasRemain) {
                CompletionHandler<Number, Object> completionHandler = this.readCompletionHandler;
                Object attach = this.readAttachment;
                ByteBufferArray scattering = this.scatteringReadBuffer;
                this.resetRead();
                if (scattering == null) {
                    completionHandler.completed((int)readSize, attach);
                } else {
                    completionHandler.completed(readSize, attach);
                }
                if (!this.readPending && this.readSelectionKey != null) {
                    this.group.removeOps(this.readSelectionKey, 1);
                }
            } else if (this.readSelectionKey == null) {
                this.readWorker.addRegister(selector -> {
                    try {
                        this.readSelectionKey = this.channel.register((Selector)selector, 1, this);
                    }
                    catch (ClosedChannelException e) {
                        this.readCompletionHandler.failed(e, this.readAttachment);
                    }
                });
            } else {
                this.group.interestOps(this.readWorker, this.readSelectionKey, 1);
            }
        }
        catch (Throwable e) {
            if (this.readCompletionHandler == null) {
                e.printStackTrace();
                try {
                    this.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            this.readCompletionHandler.failed(e, this.readAttachment);
        }
    }

    private void resetRead() {
        this.readPending = false;
        this.readFuture = null;
        this.readCompletionHandler = null;
        this.readAttachment = null;
        this.readBuffer = null;
        this.scatteringReadBuffer = null;
    }

    public void doWrite() {
        try {
            if (this.writeFuture != null && this.writeFuture.isDone()) {
                this.resetWrite();
                return;
            }
            int invoker = 0;
            if (this.writeWorker.getWorkerThread() == Thread.currentThread()) {
                invoker = ++this.writeWorker.invoker;
            } else if (this.readWorker.getWorkerThread() != Thread.currentThread()) {
                invoker = ++this.writeInvoker;
            }
            int writeSize = 0;
            boolean hasRemain = true;
            if (invoker < 8) {
                if (this.gatheringWriteBuffer != null) {
                    writeSize = (int)this.channel.write(this.gatheringWriteBuffer.getBuffers(), this.gatheringWriteBuffer.getOffset(), this.gatheringWriteBuffer.getLength());
                    hasRemain = this.hasRemaining(this.gatheringWriteBuffer);
                } else {
                    writeSize = this.channel.write(this.writeBuffer);
                    hasRemain = this.writeBuffer.hasRemaining();
                }
            } else {
                this.writeInvoker = 0;
            }
            if (this.writeFuture != null && writeSize == 0) {
                this.group.removeOps(this.writeSelectionKey, 4);
                this.group.registerFuture(selector -> {
                    try {
                        this.writeFutureSelectionKey = this.channel.register((Selector)selector, 4, this);
                    }
                    catch (ClosedChannelException e) {
                        e.printStackTrace();
                        this.doWrite();
                    }
                }, 4);
                return;
            }
            if (writeSize != 0 || !hasRemain) {
                CompletionHandler<Number, Object> completionHandler = this.writeCompletionHandler;
                Object attach = this.writeAttachment;
                this.resetWrite();
                completionHandler.completed(writeSize, attach);
            } else if (this.writeSelectionKey == null) {
                this.writeWorker.addRegister(selector -> {
                    try {
                        this.writeSelectionKey = this.channel.register((Selector)selector, 4, this);
                    }
                    catch (ClosedChannelException e) {
                        this.writeCompletionHandler.failed(e, this.writeAttachment);
                    }
                });
            } else {
                this.group.interestOps(this.writeWorker, this.writeSelectionKey, 4);
            }
        }
        catch (Throwable e) {
            if (this.writeCompletionHandler == null) {
                e.printStackTrace();
                try {
                    this.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            this.writeCompletionHandler.failed(e, this.writeAttachment);
        }
    }

    private boolean hasRemaining(ByteBufferArray scattering) {
        for (int i = 0; i < scattering.getLength(); ++i) {
            if (!scattering.getBuffers()[scattering.getOffset() + i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    private void resetWrite() {
        this.writePending = false;
        this.writeFuture = null;
        this.writeAttachment = null;
        this.writeCompletionHandler = null;
        this.writeBuffer = null;
        this.gatheringWriteBuffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }
}

