/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.SafariLocator;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriverServer;
import org.openqa.selenium.safari.SafariExtensions;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.safari.SessionData;
import org.openqa.selenium.safari.WebSocketConnection;

class SafariDriverCommandExecutor
implements CommandExecutor {
    private static final Logger log = Logger.getLogger(SafariDriverCommandExecutor.class.getName());
    private final SafariExtensions safariExtensions;
    private final SafariDriverServer server;
    private final BrowserLocator browserLocator;
    private final SessionData sessionData;
    private final boolean cleanSession;
    private CommandLine commandLine;
    private WebSocketConnection connection;

    SafariDriverCommandExecutor(SafariOptions options) {
        this.safariExtensions = new SafariExtensions(options);
        this.server = new SafariDriverServer(options.getPort());
        this.browserLocator = new SafariLocator();
        this.sessionData = SessionData.forCurrentPlatform();
        this.cleanSession = options.getUseCleanSession();
    }

    synchronized void start() throws IOException {
        if (this.commandLine != null) {
            return;
        }
        this.server.start();
        this.safariExtensions.install();
        if (this.cleanSession) {
            this.sessionData.clear();
        }
        File connectFile = this.prepareConnectFile(this.server.getUri());
        BrowserInstallation installation = this.browserLocator.findBrowserLocationOrFail();
        log.info("Launching Safari");
        this.commandLine = new CommandLine(installation.launcherFilePath(), new String[]{connectFile.getAbsolutePath()});
        this.commandLine.executeAsync();
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            log.info("Waiting for SafariDriver to connect");
            this.connection = this.server.getConnection(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (this.connection == null) {
            this.stop();
            throw new UnreachableBrowserException(String.format("Failed to connect to SafariDriver after %d ms", stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
        log.info(String.format("Driver connected in %d ms", stopwatch.elapsed(TimeUnit.MILLISECONDS)));
    }

    private File prepareConnectFile(String serverUri) throws IOException {
        File tmpDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "safaridriver");
        File launchFile = new File(tmpDir, "connect.html");
        launchFile.deleteOnExit();
        String contents = String.format("<!DOCTYPE html><script>window.location = '%s';</script>", serverUri);
        Files.write((CharSequence)contents, (File)launchFile, (Charset)Charsets.UTF_8);
        return launchFile;
    }

    synchronized void stop() {
        log.info("Shutting down");
        if (this.connection != null) {
            log.info("Closing connection");
            this.connection.close();
            this.connection = null;
        }
        if (this.commandLine != null) {
            log.info("Stopping Safari");
            this.commandLine.destroy();
            this.commandLine = null;
        }
        log.info("Stopping server");
        this.server.stop();
        try {
            log.info("Uninstalling extensions");
            this.safariExtensions.uninstall();
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to uninstall extensions", (Throwable)e);
        }
        log.info("Shutdown complete");
    }

    public synchronized Response execute(Command command) {
        if (!this.server.isRunning() && "quit".equals(command.getName())) {
            Response itsOkToQuitMultipleTimes = new Response();
            itsOkToQuitMultipleTimes.setStatus(0);
            return itsOkToQuitMultipleTimes;
        }
        Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (Object)"Executor has not been started yet");
        if ("quit".equals(command.getName())) {
            Response response = new Response(command.getSessionId());
            response.setStatus(0);
            response.setState("success");
            return response;
        }
        try {
            SafariCommand safariCommand = new SafariCommand(command);
            String rawJsonCommand = new BeanToJsonConverter().convert((Object)SafariDriverCommandExecutor.serialize(safariCommand));
            ListenableFuture<String> futureResponse = this.connection.send(rawJsonCommand);
            JsonObject jsonResponse = new JsonParser().parse((String)futureResponse.get()).getAsJsonObject();
            Response response = (Response)new JsonToBeanConverter().convert(Response.class, (Object)jsonResponse.get("response"));
            if (response.getStatus() == 0) {
                Preconditions.checkArgument((boolean)safariCommand.getId().equals(jsonResponse.get("id").getAsString()), (String)"Response ID<%s> does not match command ID<%s>", (Object[])new Object[]{jsonResponse.get("id").getAsString(), safariCommand.getId()});
            }
            return response;
        }
        catch (JsonSyntaxException e) {
            throw new JsonException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static JsonElement serialize(SafariCommand command) {
        JsonObject rawJsonCommand = new BeanToJsonConverter().convertObject((Object)command).getAsJsonObject();
        JsonObject serialized = new JsonObject();
        serialized.addProperty("origin", "webdriver");
        serialized.addProperty("type", "command");
        serialized.add("command", (JsonElement)rawJsonCommand);
        return serialized;
    }

    private static class SafariCommand
    extends Command {
        private final UUID id = UUID.randomUUID();

        private SafariCommand(Command command) {
            super(command.getSessionId(), command.getName(), command.getParameters());
        }

        public String getId() {
            return this.id.toString();
        }
    }
}

