/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpRequest
extends HttpMessage {
    private final HttpMethod method;
    private final String uri;
    private final Multimap<String, String> queryParameters = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newLinkedList);

    public HttpRequest(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name) {
        return this.queryParameters.get((Object)name).stream().findFirst().orElse(null);
    }

    public void addQueryParameter(String name, String value) {
        this.queryParameters.put((Object)Objects.requireNonNull(name, "Name must be set"), (Object)Objects.requireNonNull(value, "Value must be set"));
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.queryParameters.get((Object)name);
    }
}

