/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class JdkHttpMessages {
    private final ClientConfig config;

    public JdkHttpMessages(ClientConfig config) {
        this.config = Objects.requireNonNull(config, "Client config");
    }

    public java.net.http.HttpRequest createRequest(HttpRequest req) {
        Object rawUrl = this.getRawUrl(this.config.baseUri(), req.getUri());
        String queryString = StreamSupport.stream(req.getQueryParameterNames().spliterator(), false).map(name -> StreamSupport.stream(req.getQueryParameters(name).spliterator(), false).map(value -> String.format("%s=%s", URLEncoder.encode(name, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8))).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
        if (!queryString.isEmpty()) {
            rawUrl = (String)rawUrl + "?" + queryString;
        }
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create((String)rawUrl));
        switch (req.getMethod()) {
            case DELETE: {
                builder = builder.DELETE();
                break;
            }
            case GET: {
                builder = builder.GET();
                break;
            }
            case POST: {
                builder = builder.POST(HttpRequest.BodyPublishers.ofByteArray(Contents.bytes((Supplier)req.getContent())));
                break;
            }
            case PUT: {
                builder = builder.PUT(HttpRequest.BodyPublishers.ofByteArray(Contents.bytes((Supplier)req.getContent())));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported request method %s: %s", req.getMethod(), req));
            }
        }
        for (String name2 : req.getHeaderNames()) {
            if (name2.equalsIgnoreCase("content-length")) continue;
            for (String value : req.getHeaders(name2)) {
                builder = builder.header(name2, value);
            }
        }
        if (req.getHeader("User-Agent") == null) {
            builder = builder.header("User-Agent", AddSeleniumUserAgent.USER_AGENT);
        }
        builder.timeout(this.config.readTimeout());
        return builder.build();
    }

    private String getRawUrl(URI baseUrl, String uri) {
        Object rawUrl = uri.startsWith("ws://") || uri.startsWith("wss://") || uri.startsWith("http://") || uri.startsWith("https://") ? uri : baseUrl.toString().replaceAll("/$", "") + uri;
        return rawUrl;
    }

    public URI getRawUri(HttpRequest req) {
        String rawUrl = this.getRawUrl(this.config.baseUri(), req.getUri());
        return URI.create(rawUrl);
    }

    public HttpResponse createResponse(java.net.http.HttpResponse<byte[]> response) {
        HttpResponse res = new HttpResponse();
        res.setStatus(response.statusCode());
        response.headers().map().forEach((name, values) -> values.stream().filter(Objects::nonNull).forEach(value -> res.addHeader(name, value)));
        res.setContent(() -> new ByteArrayInputStream((byte[])response.body()));
        return res;
    }
}

