/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.indexeddb.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v90.indexeddb.model.Key;
import org.openqa.selenium.json.JsonInput;

public class KeyRange {
    private final Optional<Key> lower;
    private final Optional<Key> upper;
    private final Boolean lowerOpen;
    private final Boolean upperOpen;

    public KeyRange(Optional<Key> lower, Optional<Key> upper, Boolean lowerOpen, Boolean upperOpen) {
        this.lower = lower;
        this.upper = upper;
        this.lowerOpen = Objects.requireNonNull(lowerOpen, "lowerOpen is required");
        this.upperOpen = Objects.requireNonNull(upperOpen, "upperOpen is required");
    }

    public Optional<Key> getLower() {
        return this.lower;
    }

    public Optional<Key> getUpper() {
        return this.upper;
    }

    public Boolean getLowerOpen() {
        return this.lowerOpen;
    }

    public Boolean getUpperOpen() {
        return this.upperOpen;
    }

    private static KeyRange fromJson(JsonInput input) {
        Optional<Key> lower = Optional.empty();
        Optional<Key> upper = Optional.empty();
        Boolean lowerOpen = false;
        Boolean upperOpen = false;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lower": {
                    lower = Optional.ofNullable((Key)input.read(Key.class));
                    continue block12;
                }
                case "upper": {
                    upper = Optional.ofNullable((Key)input.read(Key.class));
                    continue block12;
                }
                case "lowerOpen": {
                    lowerOpen = input.nextBoolean();
                    continue block12;
                }
                case "upperOpen": {
                    upperOpen = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new KeyRange(lower, upper, lowerOpen, upperOpen);
    }
}

