/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v122.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v122.audits.model.AttributionReportingIssueType;
import org.openqa.selenium.devtools.v122.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AttributionReportingIssueDetails {
    private final AttributionReportingIssueType violationType;
    private final Optional<AffectedRequest> request;
    private final Optional<BackendNodeId> violatingNodeId;
    private final Optional<String> invalidParameter;

    public AttributionReportingIssueDetails(AttributionReportingIssueType violationType, Optional<AffectedRequest> request, Optional<BackendNodeId> violatingNodeId, Optional<String> invalidParameter) {
        this.violationType = Objects.requireNonNull(violationType, "violationType is required");
        this.request = request;
        this.violatingNodeId = violatingNodeId;
        this.invalidParameter = invalidParameter;
    }

    public AttributionReportingIssueType getViolationType() {
        return this.violationType;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    public Optional<String> getInvalidParameter() {
        return this.invalidParameter;
    }

    private static AttributionReportingIssueDetails fromJson(JsonInput input) {
        AttributionReportingIssueType violationType = null;
        Optional<AffectedRequest> request = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        Optional<String> invalidParameter = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "violationType": {
                    violationType = (AttributionReportingIssueType)((Object)input.read(AttributionReportingIssueType.class));
                    continue block12;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block12;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block12;
                }
                case "invalidParameter": {
                    invalidParameter = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingIssueDetails(violationType, request, violatingNodeId, invalidParameter);
    }
}

