/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;

public class HostIdentifier {
    private static final String HOST_NAME;
    private static final String HOST_ADDRESS;

    public static String getHostName() {
        return HOST_NAME;
    }

    public static String getHostAddress() {
        return HOST_ADDRESS;
    }

    static {
        String host;
        block26: {
            host = System.getenv("HOSTNAME");
            if (host == null) {
                host = System.getenv("COMPUTERNAME");
            }
            if (host == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec("hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block26;
                    try (InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                         BufferedReader reader = new BufferedReader(isr);){
                        host = reader.readLine();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "Unknown";
            }
        }
        HOST_NAME = host;
        String address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                NetworkInterface en0 = NetworkInterface.getByName("en0");
                Enumeration<InetAddress> addresses = en0.getInetAddresses();
                if (addresses.hasMoreElements()) {
                    address = addresses.nextElement().getHostAddress();
                }
            }
            catch (Exception en0) {
                // empty catch block
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                address = "Unknown";
            }
        }
        HOST_ADDRESS = address;
    }
}

