/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.security;

import java.util.ArrayList;
import java.util.Set;
import org.seleniumhq.jetty9.security.AbstractLoginService;
import org.seleniumhq.jetty9.security.PropertyUserStore;
import org.seleniumhq.jetty9.server.UserIdentity;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.resource.Resource;

public class HashLoginService
extends AbstractLoginService {
    private static final Logger LOG = Log.getLogger(HashLoginService.class);
    protected PropertyUserStore _propertyUserStore;
    protected String _config;
    protected Resource _configResource;
    protected boolean hotReload = false;

    public HashLoginService() {
    }

    public HashLoginService(String name) {
        this.setName(name);
    }

    public HashLoginService(String name, String config) {
        this.setName(name);
        this.setConfig(config);
    }

    public String getConfig() {
        return this._config;
    }

    public void getConfig(String config) {
        this._config = config;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    public void setHotReload(boolean enable) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = enable;
    }

    @Override
    protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
        UserIdentity id = this._propertyUserStore.getUserIdentity(user.getName());
        if (id == null) {
            return null;
        }
        Set<AbstractLoginService.RolePrincipal> roles = id.getSubject().getPrincipals(AbstractLoginService.RolePrincipal.class);
        if (roles == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (AbstractLoginService.RolePrincipal r : roles) {
            list.add(r.getName());
        }
        return list.toArray(new String[roles.size()]);
    }

    @Override
    protected AbstractLoginService.UserPrincipal loadUserInfo(String userName) {
        UserIdentity id = this._propertyUserStore.getUserIdentity(userName);
        if (id != null) {
            return (AbstractLoginService.UserPrincipal)id.getUserPrincipal();
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._propertyUserStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doStart: Starting new PropertyUserStore. PropertiesFile: " + this._config + " hotReload: " + this.hotReload, new Object[0]);
            }
            this._propertyUserStore = new PropertyUserStore();
            this._propertyUserStore.setHotReload(this.hotReload);
            this._propertyUserStore.setConfigPath(this._config);
            this._propertyUserStore.start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._propertyUserStore != null) {
            this._propertyUserStore.stop();
        }
        this._propertyUserStore = null;
    }
}

