/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.htmlunit.CookieManager;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitTimeouts;
import org.openqa.selenium.htmlunit.HtmlUnitWindow;
import org.openqa.selenium.htmlunit.logging.HtmlUnitLogs;
import org.openqa.selenium.logging.Logs;

public class HtmlUnitOptions
implements WebDriver.Options {
    private final HtmlUnitLogs logs_;
    private final HtmlUnitDriver driver_;
    private final HtmlUnitTimeouts timeouts_;

    public HtmlUnitOptions(HtmlUnitDriver driver) {
        this.driver_ = driver;
        this.logs_ = new HtmlUnitLogs(this.getWebClient());
        this.timeouts_ = new HtmlUnitTimeouts(this.getWebClient());
    }

    public Logs logs() {
        return this.logs_;
    }

    public void addCookie(Cookie cookie) {
        Page page = this.window().lastPage();
        if (!(page instanceof HtmlPage)) {
            throw new UnableToSetCookieException("You may not set cookies on a page that is not HTML");
        }
        String domain = this.getDomainForCookie();
        this.verifyDomain(cookie, domain);
        this.getWebClient().getCookieManager().addCookie(new org.htmlunit.util.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getSameSite()));
    }

    private void verifyDomain(Cookie cookie, String expectedDomain) {
        Object domain = cookie.getDomain();
        if (domain == null) {
            return;
        }
        if ("".equals(domain)) {
            throw new InvalidCookieDomainException("Domain must not be an empty string. Consider using null instead");
        }
        if (((String)domain).matches(".*[^:]:\\d+$")) {
            domain = ((String)domain).replaceFirst(":\\d+$", "");
        }
        expectedDomain = ((String)expectedDomain).startsWith(".") ? expectedDomain : "." + (String)expectedDomain;
        Object object = domain = ((String)domain).startsWith(".") ? domain : "." + (String)domain;
        if (!((String)expectedDomain).endsWith((String)domain)) {
            throw new InvalidCookieDomainException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
        }
    }

    public Cookie getCookieNamed(String name) {
        Set<Cookie> allCookies = this.getCookies();
        for (Cookie cookie : allCookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void deleteCookieNamed(String name) {
        CookieManager cookieManager = this.getWebClient().getCookieManager();
        URL url = this.getRawUrl();
        Set rawCookies = this.getWebClient().getCookies(url);
        for (org.htmlunit.util.Cookie cookie : rawCookies) {
            if (!name.equals(cookie.getName())) continue;
            cookieManager.removeCookie(cookie);
        }
    }

    public void deleteCookie(Cookie cookie) {
        this.getWebClient().getCookieManager().removeCookie(this.convertSeleniumCookieToHtmlUnit(cookie));
    }

    public void deleteAllCookies() {
        CookieManager cookieManager = this.getWebClient().getCookieManager();
        URL url = this.getRawUrl();
        Set rawCookies = this.getWebClient().getCookies(url);
        for (org.htmlunit.util.Cookie cookie : rawCookies) {
            cookieManager.removeCookie(cookie);
        }
    }

    public Set<Cookie> getCookies() {
        URL url = this.getRawUrl();
        if (!url.toString().startsWith("http")) {
            return Collections.emptySet();
        }
        HashSet<Cookie> result = new HashSet<Cookie>();
        for (org.htmlunit.util.Cookie c : this.getWebClient().getCookies(url)) {
            result.add(new Cookie.Builder(c.getName(), c.getValue()).domain(c.getDomain()).path(c.getPath()).expiresOn(c.getExpires()).isSecure(c.isSecure()).isHttpOnly(c.isHttpOnly()).sameSite(c.getSameSite()).build());
        }
        return Collections.unmodifiableSet(result);
    }

    private org.htmlunit.util.Cookie convertSeleniumCookieToHtmlUnit(Cookie cookie) {
        return new org.htmlunit.util.Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getSameSite());
    }

    private String getDomainForCookie() {
        URL current = this.getRawUrl();
        return current.getHost();
    }

    private WebClient getWebClient() {
        return this.driver_.getWebClient();
    }

    public WebDriver.Timeouts timeouts() {
        return this.timeouts_;
    }

    public HtmlUnitWindow window() {
        return this.driver_.getCurrentWindow();
    }

    private URL getRawUrl() {
        return Optional.ofNullable(this.window().lastPage()).map(Page::getUrl).orElse(null);
    }
}

