/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomNodeList;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.w3c.dom.Node;

public class HtmlUnitElementFinder {
    private static final String INVALIDXPATHERROR = "The xpath expression '%s' cannot be evaluated";
    private static final String INVALIDSELECTIONERROR = "The xpath expression '%s' selected an object of type '%s' instead of a WebElement";
    private final Map<Class<? extends By>, HtmlUnitElementLocator> finders_ = new HashMap<Class<? extends By>, HtmlUnitElementLocator>();

    HtmlUnitElementFinder() {
        this.finders_.put(By.id((String)"a").getClass(), new FindByID());
        this.finders_.put(By.name((String)"a").getClass(), new FindByName());
        this.finders_.put(By.linkText((String)"a").getClass(), new FindByLinkText());
        this.finders_.put(By.partialLinkText((String)"a").getClass(), new FindByPartialLinkText());
        this.finders_.put(By.className((String)"a").getClass(), new FindByClassName());
        this.finders_.put(By.cssSelector((String)"a").getClass(), new FindByCssSelector());
        this.finders_.put(By.tagName((String)"a").getClass(), new FindByTagName());
        this.finders_.put(By.xpath((String)"//a").getClass(), new FindByXPath());
    }

    public WebElement findElement(HtmlUnitDriver driver, By locator) {
        HtmlUnitElementLocator elementLocator = this.finders_.get(locator.getClass());
        if (elementLocator == null) {
            return locator.findElement((SearchContext)driver);
        }
        return elementLocator.findElement(driver, locator);
    }

    public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
        HtmlUnitElementLocator elementLocator = this.finders_.get(locator.getClass());
        if (elementLocator == null) {
            return locator.findElements((SearchContext)driver);
        }
        return elementLocator.findElements(driver, locator);
    }

    public WebElement findElement(HtmlUnitWebElement element, By locator) {
        HtmlUnitElementLocator elementLocator = this.finders_.get(locator.getClass());
        if (elementLocator == null) {
            return locator.findElement((SearchContext)element);
        }
        return elementLocator.findElement(element, locator);
    }

    public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
        HtmlUnitElementLocator elementLocator = this.finders_.get(locator.getClass());
        if (elementLocator == null) {
            return locator.findElements((SearchContext)element);
        }
        return elementLocator.findElements(element, locator);
    }

    private static List<WebElement> convertRawDomElementsToWebElements(HtmlUnitDriver driver, List<DomElement> nodes) {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(nodes.size());
        for (DomElement node : nodes) {
            toReturn.add(driver.toWebElement(node));
        }
        return toReturn;
    }

    public static abstract class HtmlUnitElementLocator {
        public WebElement findElement(HtmlUnitDriver driver, By locator) {
            List<WebElement> toReturn = this.findElements(driver, locator);
            if (!toReturn.isEmpty()) {
                return toReturn.get(0);
            }
            throw new NoSuchElementException("Unable to locate element");
        }

        public abstract List<WebElement> findElements(HtmlUnitDriver var1, By var2);

        public WebElement findElement(HtmlUnitWebElement element, By locator) {
            List<WebElement> toReturn = this.findElements(element, locator);
            if (!toReturn.isEmpty()) {
                return toReturn.get(0);
            }
            throw new NoSuchElementException("Unable to locate element");
        }

        public abstract List<WebElement> findElements(HtmlUnitWebElement var1, By var2);

        protected static By.Remotable getRemotable(By locator) {
            if (!(locator instanceof By.Remotable)) {
                throw new IllegalStateException("Cannot convert locator to Remotable");
            }
            return (By.Remotable)locator;
        }

        protected SgmlPage getLastPage(HtmlUnitDriver driver) {
            Page lastPage = driver.getCurrentWindow().lastPage();
            if (!(lastPage instanceof SgmlPage)) {
                throw new IllegalStateException("Current page is not a SgmlPage");
            }
            return (SgmlPage)lastPage;
        }

        protected static String getValue(By locator) {
            By.Remotable remote = HtmlUnitElementLocator.getRemotable(locator);
            return (String)remote.getRemoteParameters().value();
        }
    }

    public static class FindByXPath
    extends HtmlUnitElementLocator {
        @Override
        public WebElement findElement(HtmlUnitDriver driver, By locator) {
            Object node;
            SgmlPage lastPage = this.getLastPage(driver);
            String value = FindByXPath.getValue(locator);
            try {
                node = lastPage.getFirstByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDXPATHERROR, value), (Throwable)ex);
            }
            if (node == null) {
                throw new NoSuchElementException("Unable to locate a node using " + value);
            }
            if (node instanceof DomElement) {
                return driver.toWebElement((DomElement)node);
            }
            throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDSELECTIONERROR, value, node.getClass()));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            List nodes;
            SgmlPage lastPage;
            try {
                lastPage = this.getLastPage(driver);
            }
            catch (IllegalStateException e) {
                return Collections.emptyList();
            }
            String value = FindByXPath.getValue(locator);
            try {
                nodes = lastPage.getByXPath(value);
            }
            catch (RuntimeException ex) {
                throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDXPATHERROR, value), (Throwable)ex);
            }
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>(nodes.size());
            for (Object node : nodes) {
                if (!(node instanceof DomElement)) {
                    throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDSELECTIONERROR, value, node.getClass()));
                }
                toReturn.add(driver.toWebElement((DomElement)node));
            }
            return toReturn;
        }

        @Override
        public WebElement findElement(HtmlUnitWebElement element, By locator) {
            Object node;
            String value = FindByXPath.getValue(locator);
            try {
                node = element.getElement().getFirstByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDXPATHERROR, value), (Throwable)ex);
            }
            if (node == null) {
                throw new NoSuchElementException("Unable to find an element with xpath " + value);
            }
            if (node instanceof HtmlElement) {
                return element.getDriver().toWebElement((DomElement)((HtmlElement)node));
            }
            throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDSELECTIONERROR, value, node.getClass().toString()));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            List domElements;
            String value = FindByXPath.getValue(locator);
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            try {
                domElements = element.getElement().getByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDXPATHERROR, value), (Throwable)ex);
            }
            for (Object e : domElements) {
                if (e instanceof DomElement) {
                    toReturn.add(element.getDriver().toWebElement((DomElement)e));
                    continue;
                }
                throw new InvalidSelectorException(String.format(HtmlUnitElementFinder.INVALIDSELECTIONERROR, value, e.getClass().toString()));
            }
            return toReturn;
        }
    }

    public static class FindByTagName
    extends HtmlUnitElementLocator {
        @Override
        public WebElement findElement(HtmlUnitDriver driver, By locator) {
            DomNodeList allElements = this.getLastPage(driver).getElementsByTagName(FindByTagName.getValue(locator));
            if (allElements.getLength() > 0) {
                return driver.toWebElement((DomElement)((HtmlElement)allElements.item(0)));
            }
            throw new NoSuchElementException("Unable to locate element with name: " + FindByTagName.getValue(locator));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage;
            String name = FindByTagName.getValue(locator);
            if ("".equals(name)) {
                throw new InvalidSelectorException("Unable to locate element by xpath for " + this.getLastPage(driver));
            }
            try {
                lastPage = this.getLastPage(driver);
            }
            catch (IllegalStateException e) {
                return Collections.emptyList();
            }
            DomNodeList allElements = lastPage.getElementsByTagName(name);
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
            for (int i = 0; i < allElements.getLength(); ++i) {
                Node item = allElements.item(i);
                if (!(item instanceof DomElement)) continue;
                toReturn.add(driver.toWebElement((DomElement)item));
            }
            return toReturn;
        }

        @Override
        public WebElement findElement(HtmlUnitWebElement element, By locator) {
            DomNodeList allElements = element.getElement().getElementsByTagName(FindByTagName.getValue(locator));
            if (allElements.getLength() > 0) {
                return element.getDriver().toWebElement((DomElement)((HtmlElement)allElements.item(0)));
            }
            throw new NoSuchElementException("Unable to locate element with name: " + FindByTagName.getValue(locator));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            DomNodeList allElements = element.getElement().getElementsByTagName(FindByTagName.getValue(locator));
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
            for (int i = 0; i < allElements.getLength(); ++i) {
                Node item = allElements.item(i);
                if (!(item instanceof DomElement)) continue;
                toReturn.add(element.getDriver().toWebElement((DomElement)item));
            }
            return toReturn;
        }
    }

    public static class FindByCssSelector
    extends HtmlUnitElementLocator {
        @Override
        public WebElement findElement(HtmlUnitDriver driver, By locator) {
            DomNode node;
            try {
                node = this.getLastPage(driver).querySelector(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            if (node instanceof DomElement) {
                return driver.toWebElement((DomElement)node);
            }
            throw new NoSuchElementException("Returned node (" + node + ") was not a DOM element");
        }

        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            DomNodeList allNodes;
            try {
                allNodes = this.getLastPage(driver).querySelectorAll(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (DomNode node : allNodes) {
                if (node instanceof DomElement) {
                    toReturn.add(driver.toWebElement((DomElement)node));
                    continue;
                }
                throw new NoSuchElementException("Returned node was not a DOM element");
            }
            return toReturn;
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            DomNodeList allNodes;
            try {
                allNodes = element.getElement().querySelectorAll(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (DomNode node : allNodes) {
                if (node instanceof DomElement) {
                    toReturn.add(element.getDriver().toWebElement((DomElement)node));
                    continue;
                }
                throw new NoSuchElementException("Returned node was not a DOM element");
            }
            return toReturn;
        }

        @Override
        public WebElement findElement(HtmlUnitWebElement element, By locator) {
            DomNode node;
            try {
                node = element.getElement().querySelector(FindByCssSelector.getValue(locator));
            }
            catch (CSSException ex) {
                throw new NoSuchElementException("Unable to locate element using css", (Throwable)ex);
            }
            if (node instanceof DomElement) {
                return element.getDriver().toWebElement((DomElement)node);
            }
            throw new NoSuchElementException("Returned node (" + node + ") was not a DOM element");
        }
    }

    public static class FindByClassName
    extends HtmlUnitElementLocator {
        private String checkValue(By locator) {
            String value = FindByClassName.getValue(locator);
            if (value.indexOf(32) != -1) {
                throw new NoSuchElementException("Compound class names not permitted");
            }
            return value;
        }

        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            return new FindByCssSelector().findElements(driver, By.cssSelector((String)("." + this.checkValue(locator))));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            return new FindByCssSelector().findElements(element, By.cssSelector((String)("." + this.checkValue(locator))));
        }
    }

    public static class FindByPartialLinkText
    extends HtmlUnitElementLocator {
        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage = this.getLastPage(driver);
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find links for " + lastPage);
            }
            String expectedText = FindByPartialLinkText.getValue(locator);
            List anchors = ((HtmlPage)lastPage).getAnchors();
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (HtmlAnchor anchor : anchors) {
                if (!anchor.asNormalizedText().contains(expectedText)) continue;
                toReturn.add(driver.toWebElement((DomElement)anchor));
            }
            return toReturn;
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            String expectedText = FindByPartialLinkText.getValue(locator);
            DomNodeList anchors = element.getElement().getElementsByTagName("a");
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (HtmlElement anchor : anchors) {
                if (!anchor.asNormalizedText().contains(expectedText)) continue;
                toReturn.add(element.getDriver().toWebElement((DomElement)anchor));
            }
            return toReturn;
        }
    }

    public static class FindByLinkText
    extends HtmlUnitElementLocator {
        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage = this.getLastPage(driver);
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find links for " + lastPage);
            }
            String expectedText = FindByLinkText.getValue(locator);
            List anchors = ((HtmlPage)lastPage).getAnchors();
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (HtmlAnchor anchor : anchors) {
                if (!expectedText.equals(anchor.asNormalizedText())) continue;
                toReturn.add(driver.toWebElement((DomElement)anchor));
            }
            return toReturn;
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            String expectedText = FindByLinkText.getValue(locator);
            DomNodeList htmlElements = element.getElement().getElementsByTagName("a");
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
            for (DomElement e : htmlElements) {
                if (!expectedText.equals(e.asNormalizedText())) continue;
                toReturn.add(element.getDriver().toWebElement(e));
            }
            return toReturn;
        }
    }

    public static class FindByName
    extends HtmlUnitElementLocator {
        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage = this.getLastPage(driver);
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            List allElements = ((HtmlPage)lastPage).getElementsByName(FindByName.getValue(locator));
            return HtmlUnitElementFinder.convertRawDomElementsToWebElements(driver, allElements);
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            String name = FindByName.getValue(locator);
            return new FindByXPath().findElements(element, By.xpath((String)(".//*[@name = '" + name + "']")));
        }
    }

    public static class FindByID
    extends HtmlUnitElementLocator {
        @Override
        public WebElement findElement(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage = this.getLastPage(driver);
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            String id = FindByID.getValue(locator);
            DomElement element = ((HtmlPage)lastPage).getElementById(id);
            if (element == null) {
                throw new NoSuchElementException("Unable to locate element with ID: '" + id + "'");
            }
            return driver.toWebElement(element);
        }

        @Override
        public List<WebElement> findElements(HtmlUnitDriver driver, By locator) {
            SgmlPage lastPage = this.getLastPage(driver);
            if (!(lastPage instanceof HtmlPage)) {
                throw new IllegalStateException("Cannot find elements by id for " + lastPage);
            }
            List allElements = ((HtmlPage)lastPage).getElementsById(FindByID.getValue(locator));
            return HtmlUnitElementFinder.convertRawDomElementsToWebElements(driver, allElements);
        }

        @Override
        public WebElement findElement(HtmlUnitWebElement element, By locator) {
            String id = FindByID.getValue(locator);
            return new FindByXPath().findElement(element, By.xpath((String)(".//*[@id = '" + id + "']")));
        }

        @Override
        public List<WebElement> findElements(HtmlUnitWebElement element, By locator) {
            String id = FindByID.getValue(locator);
            return new FindByXPath().findElements(element, By.xpath((String)(".//*[@id = '" + id + "']")));
        }
    }
}

