/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.utils.F;
import org.rythmengine.utils.S;

public abstract class Range<TYPE extends Comparable<TYPE>>
implements Iterable<TYPE> {
    private final TYPE minInclusive;
    private TYPE maxExclusive;
    private static final Pattern P_NUM = Pattern.compile("([0-9]+)(\\s*\\.\\.\\s*|\\s+(to|till)\\s+)([0-9]+)");
    private static final Pattern P_CHR = Pattern.compile("'(\\w)'(\\s*\\.\\.\\s*|\\s+(to|till)\\s+)'(\\w)'");

    public Range(TYPE minInclusive, TYPE maxExclusive) {
        if (minInclusive == null || maxExclusive == null) {
            throw new NullPointerException();
        }
        if (minInclusive.compareTo(maxExclusive) > 0) {
            throw new IllegalArgumentException("max is greater than min");
        }
        this.minInclusive = minInclusive;
        this.maxExclusive = maxExclusive;
    }

    public TYPE min() {
        return this.minInclusive;
    }

    public TYPE max() {
        return this.maxExclusive;
    }

    private void extendMax() {
        this.maxExclusive = this.next(this.maxExclusive);
    }

    protected abstract TYPE next(TYPE var1);

    public abstract boolean include(TYPE var1);

    public abstract int size();

    public String toString() {
        return Rythm.toString("[@_.min() .. @_.max())", this);
    }

    public static Range valueOf(String s) {
        Range<Comparable<Character>> r;
        boolean open = true;
        if (s.endsWith("]")) {
            open = false;
        }
        s = s.trim();
        s = S.strip(s, "[", ")");
        s = S.strip(s, "[", "]");
        Matcher m = P_NUM.matcher(s);
        boolean isChar = false;
        if (!m.matches()) {
            m = P_CHR.matcher(s);
            isChar = true;
        }
        if (!m.matches()) {
            throw new IllegalArgumentException("unknown range expression: " + s);
        }
        if (isChar) {
            char c = m.group(1).charAt(0);
            char max = m.group(4).charAt(0);
            r = F.R(c, max);
        } else {
            int n = Integer.valueOf(m.group(1));
            int max = Integer.valueOf(m.group(4));
            r = F.R(n, max);
        }
        String string = m.group(3);
        if ("till".equals(string)) {
            open = false;
        }
        if (!open) {
            super.extendMax();
        }
        return r;
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new Iterator<TYPE>(){
            private TYPE cur;
            {
                this.cur = Range.this.minInclusive;
            }

            @Override
            public boolean hasNext() {
                return !this.cur.equals(Range.this.maxExclusive);
            }

            @Override
            public TYPE next() {
                Object retVal = this.cur;
                this.cur = Range.this.next(this.cur);
                return retVal;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

