/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.exception.DialectNotSupportException;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.dialect.Rythm;
import org.rythmengine.internal.dialect.SimpleRythm;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.Patterns;
import org.rythmengine.internal.parser.build_in.CaretParserFactoryBase;
import org.rythmengine.utils.S;

public class ExpressionParser
extends CaretParserFactoryBase {
    public static String assertBasic(String symbol, IContext context) {
        if (symbol.contains("_utils.sep(\"")) {
            return symbol;
        }
        String s = symbol;
        boolean isSimple = Patterns.VarName.matches(s);
        IContext ctx = context;
        if (!isSimple) {
            throw new TemplateParser.ComplexExpressionException(ctx);
        }
        return s;
    }

    public static String processPositionPlaceHolder(String s) {
        String rs = s.startsWith("@(") ? "@\\(([0-9]+)\\)" : "@([0-9]+)";
        Regex r = new Regex(rs, "__v_${1}");
        return r.replaceAll(s);
    }

    public static String reversePositionPlaceHolder(String s) {
        Regex r = new Regex("__v_([0-9]+)", "@${1}");
        return r.replaceAll(s);
    }

    @Override
    public IParser create(IContext ctx) {
        Regex r1_ = null;
        Regex r2_ = null;
        String caret_ = null;
        IDialect dialect = ctx.getDialect();
        if (dialect instanceof Rythm || dialect instanceof SimpleRythm) {
            caret_ = dialect.a();
            r1_ = new Regex(String.format(this.patternStr(), caret_));
            r2_ = new Regex(String.format("^(%s(?@())).*", caret_));
        }
        final Regex r1 = r1_;
        final Regex r2 = r2_;
        final String caret = caret_;
        if (null == r1 || null == r2) {
            throw new DialectNotSupportException(dialect.id());
        }
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String s = this.remain();
                if (r1.search(s) && (s = r1.stringMatched()).length() > 0 && !caret.equals(s.trim())) {
                    this.step(s.length());
                    s = ExpressionParser.processPositionPlaceHolder(s);
                    s = s.replaceFirst(caret, "");
                    return new ExpressionToken(s, this.ctx());
                }
                s = this.remain();
                if (r2.search(s) && null != (s = r2.stringMatched(1)) && !"@".equals(s.trim())) {
                    this.step(s.length());
                    s = ExpressionParser.processPositionPlaceHolder(s);
                    return new ExpressionToken(s.replaceFirst(caret, ""), this.ctx());
                }
                return null;
            }
        };
    }

    protected String patternStr() {
        return "^(%s[0-9a-zA-Z_][a-zA-Z0-9_\\.]*((\\.[a-zA-Z][a-zA-Z0-9_\\.]*)*(?@[])*(?@())*)((\\.[a-zA-Z_][a-zA-Z0-9_\\.]*)*(?@[])*(?@())*)*@?)*";
    }

    static class ExpressionToken
    extends CodeToken {
        public ExpressionToken(String s, IContext context) {
            super(s, context);
            CaretParserFactoryBase.checkRestrictedClass(this.ctx, s);
            if (s.contains("_utils.sep(\"")) {
                return;
            }
            if (context.getDialect() instanceof BasicRythm) {
                if (s.startsWith("(")) {
                    s = S.stripBrace(s);
                }
                s = ExpressionParser.assertBasic(s, context);
                int d = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) != '[') continue;
                    ++d;
                }
                int pos = s.indexOf("[");
                if (pos != -1) {
                    s = s.substring(0, pos);
                }
                String type = "Object";
                for (int i = 0; i < d; ++i) {
                    type = type + "[]";
                }
                context.getCodeBuilder().addRenderArgsIfNotDeclared(context.currentLine(), type, s);
            }
        }

        @Override
        public void output() {
            String tagName;
            boolean needsPrint = true;
            int pos = this.s.indexOf("(");
            if (pos != -1 && !S.isEmpty(tagName = this.s.substring(0, pos).trim())) {
                needsPrint = this.ctx.getCodeBuilder().needsPrint(tagName);
            }
            this.outputExpression(needsPrint);
        }
    }
}

